/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import io.github.sashirestela.cleverclient.http.HttpProcessor;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleverClient {
    private static final Logger logger = LoggerFactory.getLogger(CleverClient.class);
    @NonNull
    private final String baseUrl;
    private final List<String> headers;
    private final HttpClient httpClient;
    private final Function<String, String> urlInterceptor;
    private final HttpProcessor httpProcessor;

    public CleverClient(@NonNull String baseUrl, List<String> headers, HttpClient httpClient, Function<String, String> urlInterceptor, String endOfStream) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        this.baseUrl = baseUrl;
        this.headers = Optional.ofNullable(headers).orElse(List.of());
        if (this.headers.size() % 2 > 0) {
            throw new CleverClientException("Headers must be entered as pair of values in the list.", null, null);
        }
        this.httpClient = Optional.ofNullable(httpClient).orElse(HttpClient.newHttpClient());
        this.urlInterceptor = urlInterceptor;
        CleverClientSSE.setEndOfStream(endOfStream);
        this.httpProcessor = HttpProcessor.builder().baseUrl(this.baseUrl).headers(this.headers).httpClient(this.httpClient).urlInterceptor(this.urlInterceptor).build();
        logger.debug("CleverClient has been created.");
    }

    public <T> T create(Class<T> interfaceClass) {
        return this.httpProcessor.createProxy(interfaceClass);
    }

    public static CleverClientBuilder builder() {
        return new CleverClientBuilder();
    }

    @NonNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Function<String, String> getUrlInterceptor() {
        return this.urlInterceptor;
    }

    public HttpProcessor getHttpProcessor() {
        return this.httpProcessor;
    }

    public static class CleverClientBuilder {
        private String baseUrl;
        private ArrayList<String> headers;
        private HttpClient httpClient;
        private Function<String, String> urlInterceptor;
        private String endOfStream;

        CleverClientBuilder() {
        }

        public CleverClientBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        public CleverClientBuilder header(String header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public CleverClientBuilder headers(Collection<? extends String> headers) {
            if (headers == null) {
                throw new NullPointerException("headers cannot be null");
            }
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public CleverClientBuilder clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public CleverClientBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public CleverClientBuilder urlInterceptor(Function<String, String> urlInterceptor) {
            this.urlInterceptor = urlInterceptor;
            return this;
        }

        public CleverClientBuilder endOfStream(String endOfStream) {
            this.endOfStream = endOfStream;
            return this;
        }

        public CleverClient build() {
            List<String> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<String>(this.headers));
                }
            }
            return new CleverClient(this.baseUrl, headers, this.httpClient, this.urlInterceptor, this.endOfStream);
        }

        public String toString() {
            return "CleverClient.CleverClientBuilder(baseUrl=" + this.baseUrl + ", headers=" + this.headers + ", httpClient=" + this.httpClient + ", urlInterceptor=" + this.urlInterceptor + ", endOfStream=" + this.endOfStream + ")";
        }
    }
}

