/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import java.util.ArrayList;
import java.util.List;

public class JsonUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static <T> String objectToJson(T object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new CleverClientException("Cannot convert the object {0} to Json.", new Object[]{object, e});
        }
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new CleverClientException("Cannot convert the Json {0} to class {1}.", new Object[]{json, clazz.getName(), e});
        }
    }

    public static <T> List<T> jsonToList(String json, Class<T> clazz) {
        try {
            CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)objectMapper.readValue(json, (JavaType)listType);
        }
        catch (JsonProcessingException e) {
            throw new CleverClientException("Cannot convert the Json {0} to List of {1}.", new Object[]{json, clazz.getName(), e});
        }
    }

    public static <T, U> T jsonToParametricObject(String json, Class<T> clazzT, Class<U> clazzU) {
        try {
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(clazzT, new Class[]{clazzU});
            return (T)objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new CleverClientException("Cannot convert the Json {0} to class of {1}.", new Object[]{json, clazzT.getName(), e});
        }
    }
}

