/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.metadata.Metadata;
import io.github.sashirestela.cleverclient.metadata.MethodSignature;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class URLBuilder {
    private final Metadata metadata;

    public URLBuilder(Metadata metadata) {
        this.metadata = metadata;
    }

    public String build(MethodSignature method, Object[] arguments) {
        String PATH = Path.class.getSimpleName();
        String QUERY = Query.class.getSimpleName();
        Metadata.Method methodMetadata = this.metadata.getMethods().get(method);
        String url = methodMetadata.getUrl();
        List<Metadata.Parameter> pathParamList = methodMetadata.getParametersByType().get(PATH);
        List<Metadata.Parameter> queryParamList = methodMetadata.getParametersByType().get(QUERY);
        if (pathParamList.isEmpty() && queryParamList.isEmpty()) {
            return url;
        }
        url = this.replacePathParams(url, pathParamList, arguments);
        url = this.includeQueryParams(url, queryParamList, arguments);
        return url;
    }

    private String replacePathParams(String url, List<Metadata.Parameter> paramList, Object[] arguments) {
        for (Metadata.Parameter paramMetadata : paramList) {
            int index = paramMetadata.getIndex();
            String pathParam = "{" + paramMetadata.getAnnotationValue() + "}";
            url = url.replace(pathParam, arguments[index].toString());
        }
        return url;
    }

    private String includeQueryParams(String url, List<Metadata.Parameter> paramList, Object[] arguments) {
        StringBuilder queryParamBuilder = new StringBuilder();
        for (Metadata.Parameter paramMetadata : paramList) {
            int index = paramMetadata.getIndex();
            Object value = arguments[index];
            if (value == null) continue;
            String queryParam = paramMetadata.getAnnotationValue();
            if (queryParam == null || queryParam.isEmpty()) {
                this.appendQueryParams(JsonUtil.objectToMap(value), queryParamBuilder);
                continue;
            }
            this.appendQueryParam(queryParam, value, queryParamBuilder);
        }
        return url + queryParamBuilder;
    }

    protected void appendQueryParams(Map<String, ?> queryParams, StringBuilder queryParamBuilder) {
        queryParams.forEach((k, v) -> this.appendQueryParam((String)k, v, queryParamBuilder));
    }

    protected void appendQueryParam(String name, Object value, StringBuilder queryParamBuilder) {
        if (value != null) {
            queryParamBuilder.append(queryParamBuilder.length() == 0 ? (char)'?' : '&').append(URLEncoder.encode(name, StandardCharsets.UTF_8)).append('=').append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        }
    }
}

