/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import java.lang.reflect.Method;

public class ReturnType {
    private static final String ASYNC = "java.util.concurrent.CompletableFuture";
    private static final String STREAM = "java.util.stream.Stream";
    private static final String LIST = "java.util.List";
    private static final String STRING = "java.lang.String";
    private String fullClassName;
    private String[] returnTypeArray;
    private int size;
    private int lastIndex;
    private int prevLastIndex;

    public ReturnType(String fullClassName) {
        this.fullClassName = fullClassName;
        this.returnTypeArray = fullClassName.split("[<>]", 0);
        this.size = this.returnTypeArray.length;
        this.lastIndex = this.size - 1;
        this.prevLastIndex = this.size > 1 ? this.lastIndex - 1 : -1;
    }

    public ReturnType(Method method) {
        this(method.getGenericReturnType().getTypeName());
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public Class<?> getBaseClass() {
        Class<?> baseClass = null;
        try {
            baseClass = Class.forName(this.returnTypeArray[this.lastIndex]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return baseClass;
    }

    public Category category() {
        if (this.isAsync()) {
            if (this.isStream()) {
                return Category.ASYNC_STREAM;
            }
            if (this.isList()) {
                return Category.ASYNC_LIST;
            }
            if (this.isObject()) {
                return Category.ASYNC_OBJECT;
            }
            if (this.isPlainText()) {
                return Category.ASYNC_PLAIN_TEXT;
            }
            return null;
        }
        if (this.isStream()) {
            return Category.SYNC_STREAM;
        }
        if (this.isList()) {
            return Category.SYNC_LIST;
        }
        if (this.isObject()) {
            return Category.SYNC_OBJECT;
        }
        if (this.isPlainText()) {
            return Category.SYNC_PLAIN_TEXT;
        }
        return null;
    }

    public boolean isAsync() {
        return this.size > 1 && ASYNC.equals(this.returnTypeArray[0]);
    }

    public boolean isStream() {
        return this.size != 1 && STREAM.equals(this.returnTypeArray[this.prevLastIndex]);
    }

    public boolean isList() {
        return this.size != 1 && LIST.equals(this.returnTypeArray[this.prevLastIndex]);
    }

    public boolean isObject() {
        return !this.isString() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    public boolean isPlainText() {
        return this.isString() && (this.size == 1 || this.size == 2 && this.isAsync());
    }

    private boolean isString() {
        return STRING.equals(this.returnTypeArray[this.lastIndex]);
    }

    public static enum Category {
        ASYNC_STREAM,
        ASYNC_LIST,
        ASYNC_OBJECT,
        ASYNC_PLAIN_TEXT,
        SYNC_STREAM,
        SYNC_LIST,
        SYNC_OBJECT,
        SYNC_PLAIN_TEXT;

    }
}

