/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient;

import io.github.sashirestela.cleverclient.HttpProcessor;
import io.github.sashirestela.cleverclient.InvocationFilter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInvocationHandler
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(HttpInvocationHandler.class);
    private HttpProcessor processor;
    private InvocationFilter filter;

    public HttpInvocationHandler(HttpProcessor processor, InvocationFilter filter) {
        this.processor = processor;
        this.filter = filter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        logger.debug("Invoked Method : {}.{}()", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
        if (this.filter != null) {
            this.filter.apply(method, arguments);
            logger.debug("Applied Filter : {}", (Object)this.filter.getClass().getSimpleName());
        }
        Object responseObject = this.processor.resolve(method, arguments);
        logger.debug("Received Response");
        return responseObject;
    }
}

