/*
 * Decompiled with CFR 0.152.
 */
package io.github.sangkeon.opa.wasm;

import io.github.kawamuray.wasmtime.Disposable;
import io.github.kawamuray.wasmtime.Engine;
import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Linker;
import io.github.kawamuray.wasmtime.Memory;
import io.github.kawamuray.wasmtime.MemoryType;
import io.github.kawamuray.wasmtime.Module;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import io.github.kawamuray.wasmtime.wasi.WasiCtx;
import io.github.kawamuray.wasmtime.wasi.WasiCtxBuilder;
import io.github.sangkeon.opa.wasm.Bundle;
import io.github.sangkeon.opa.wasm.OPAAddr;
import io.github.sangkeon.opa.wasm.OPAErrorCode;
import io.github.sangkeon.opa.wasm.OPAExports;
import io.github.sangkeon.opa.wasm.OPAExportsAPI;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class OPAModule
implements Disposable {
    public static final String EMPTY_JSON = "{}";
    public static final String MODULE_NAME = "policy";
    private Map<Integer, String> builtinFunc = new HashMap<Integer, String>();
    private Map<String, Integer> entrypoints = new HashMap<String, Integer>();
    private Store<Void> store;
    private Linker linker;
    private WasiCtx wasi = new WasiCtxBuilder().inheritStdout().inheritStderr().build();
    private OPAExportsAPI exports;
    private Func abort;
    private Func println;
    private Func builtin0;
    private Func builtin1;
    private Func builtin2;
    private Func builtin3;
    private Func builtin4;
    private Memory memory;
    private Module module;
    private OPAAddr _dataAddr;
    private OPAAddr _baseHeapPtr;
    private OPAAddr _dataHeapPtr;
    private OPAAddr _heapPtr;

    public OPAModule(String filename) {
        this(filename, EMPTY_JSON);
    }

    public OPAModule(String filename, String json) {
        this.store = Store.withoutData();
        this.linker = new Linker(this.store.engine());
        this.module = Module.fromFile((Engine)this.store.engine(), (String)filename);
        this.initImports();
        WasiCtx.addToLinker((Linker)this.linker);
        this.linker.module(this.store, MODULE_NAME, this.module);
        this.exports = OPAExports.getOPAExports(this.linker, MODULE_NAME, this.store);
        this.loadBuiltins();
        this.loadEntrypoints();
        this._dataAddr = this.loadJson(json);
        this._baseHeapPtr = this.exports.opaHeapPtrGet();
        this._dataHeapPtr = this._baseHeapPtr.copy();
        this._heapPtr = this._baseHeapPtr.copy();
    }

    public OPAModule(Bundle bundle) {
        this.store = Store.withoutData((WasiCtx)this.wasi);
        this.linker = new Linker(this.store.engine());
        this.module = Module.fromBinary((Engine)this.store.engine(), (byte[])bundle.getPolicy());
        this.initImports();
        WasiCtx.addToLinker((Linker)this.linker);
        this.linker.module(this.store, MODULE_NAME, this.module);
        this.exports = OPAExports.getOPAExports(this.linker, MODULE_NAME, this.store);
        this.loadBuiltins();
        this.loadEntrypoints();
        this._dataAddr = this.loadJson(bundle.getData());
        this._baseHeapPtr = this.exports.opaHeapPtrGet();
        this._dataHeapPtr = this._baseHeapPtr.copy();
        this._heapPtr = this._baseHeapPtr.copy();
    }

    public Map<String, Integer> getEntrypoints() {
        return this.entrypoints;
    }

    public void loadEntrypoints() {
        this.entrypoints.clear();
        OPAAddr entrypointsAddr = this.exports.entrypoints();
        if (!entrypointsAddr.isNull()) {
            String jsonString = this.dumpJson(entrypointsAddr);
            JSONObject jObject = new JSONObject(jsonString);
            Iterator iter = jObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                int val = jObject.getInt(key);
                this.entrypoints.put(key, val);
            }
        }
    }

    public void loadBuiltins() {
        this.builtinFunc.clear();
        OPAAddr builtinaddr = this.exports.builtins();
        if (!builtinaddr.isNull()) {
            String jsonString = this.dumpJson(builtinaddr);
            JSONObject jObject = new JSONObject(jsonString);
            Iterator iter = jObject.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                int val = jObject.getInt(key);
                this.builtinFunc.put(val, key);
            }
        }
    }

    public String getFuncName(int id) {
        return this.builtinFunc.get(id);
    }

    public void dispose() {
        this.dispose(true);
    }

    public String readStringFromOPAMemory(OPAAddr addr) {
        return this.decodeNullTerminatedString(this.memory, addr);
    }

    public String evaluate(String json) {
        return this.evaluate(json, 0);
    }

    public String evaluate(String json, String entrypoint) {
        if (this.entrypoints.containsKey(entrypoint)) {
            return this.evaluate(json, this.entrypoints.get(entrypoint));
        }
        throw new RuntimeException(String.format("entrypoint %s is not valid", entrypoint));
    }

    public String evaluate(String json, int entrypoint) {
        this._heapPtr = this._dataHeapPtr.copy();
        if (this.exports.isFastPathEvalSupported()) {
            return this.evaluateFastPath(json, entrypoint);
        }
        return this.evaluateNormalPath(json, entrypoint);
    }

    private String evaluateNormalPath(String json, int entrypoint) {
        this.exports.opaHeapPtrSet(this._dataHeapPtr);
        OPAAddr inputAddr = this.loadJson(json);
        OPAAddr ctxAddr = this.exports.opaEvalCtxNew();
        this.exports.opaEvalCtxSetInput(ctxAddr, inputAddr);
        this.exports.opaEvalCtxSetData(ctxAddr, this._dataAddr);
        this.exports.opaEvalCtxSetEntryPoint(ctxAddr, entrypoint);
        OPAErrorCode err = this.exports.eval(ctxAddr);
        if (err != OPAErrorCode.OPA_ERR_OK) {
            throw new RuntimeException(String.format("evaluate error: %s", err.message()));
        }
        OPAAddr resultAddr = this.exports.opaEvalCtxGetResult(ctxAddr);
        return this.dumpJson(resultAddr);
    }

    private String evaluateFastPath(String json, int entrypoint) {
        byte[] jsonBytes = json.getBytes();
        int size = jsonBytes.length;
        ByteBuffer buf = this.memory.buffer(this.store);
        OPAAddr inputAddr = this._heapPtr.copy();
        for (int i = 0; i < size; ++i) {
            buf.put(inputAddr.getInternal() + i, jsonBytes[i]);
        }
        this._heapPtr = OPAAddr.newAddr(inputAddr.getInternal() + size);
        OPAAddr resultAddr = this.exports.opaEval(OPAAddr.newAddr(0), entrypoint, this._dataAddr, inputAddr, jsonBytes.length, this._heapPtr, 0);
        return this.decodeNullTerminatedString(this.memory, resultAddr);
    }

    public void setData(String json) {
        this.exports.opaHeapPtrSet(this._baseHeapPtr);
        this._dataAddr = this.loadJson(json);
        this._dataHeapPtr = this.exports.opaHeapPtrGet();
        this._heapPtr = this._dataHeapPtr.copy();
    }

    public OPAAddr loadJson(String json) {
        OPAAddr addr = this.writeString(this.memory, json);
        OPAAddr parseAddr = this.exports.opaJsonParse(addr, json.length());
        if (parseAddr.isNull()) {
            throw new NullPointerException("Parsing failed");
        }
        return parseAddr;
    }

    private OPAAddr writeString(Memory memory, String string) {
        byte[] stringBytes = string.getBytes();
        OPAAddr addr = this.exports.opaMalloc(stringBytes.length);
        ByteBuffer buf = memory.buffer(this.store);
        int internalAddr = addr.getInternal();
        for (int i = 0; i < stringBytes.length; ++i) {
            buf.put(internalAddr + i, stringBytes[i]);
        }
        return addr;
    }

    private String dumpJson(OPAAddr addrResult) {
        OPAAddr addr = this.exports.opaJsonDump(addrResult);
        return this.decodeNullTerminatedString(this.memory, addr);
    }

    private String decodeNullTerminatedString(Memory memory, OPAAddr addr) {
        int internalAddr;
        int end = internalAddr = addr.getInternal();
        ByteBuffer buf = memory.buffer(this.store);
        while (buf.get(end) != 0) {
            ++end;
        }
        int size = end - internalAddr;
        if (size == 0) {
            return "";
        }
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = buf.get(internalAddr + i);
        }
        return new String(result);
    }

    private void initImports() {
        this.memory = new Memory(this.store, new MemoryType(5L, false));
        this.abort = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, addr -> {
            throw new RuntimeException(this.readStringFromOPAMemory(OPAAddr.newAddr(addr)));
        });
        this.println = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, addr -> System.out.println(this.readStringFromOPAMemory(OPAAddr.newAddr(addr))));
        this.builtin0 = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (builtinId, opaCtxReserved) -> {
            String funcName = this.getFuncName((int)builtinId);
            OPAModule.checkBuiltinFunctionExists(builtinId, funcName);
            OPAModule.unsupportedFunction(builtinId, funcName);
            return 0;
        });
        this.builtin1 = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (builtinId, opaCtxReserved, addr1) -> {
            String funcName = this.getFuncName((int)builtinId);
            OPAModule.checkBuiltinFunctionExists(builtinId, funcName);
            String arg1 = this.dumpJson(OPAAddr.newAddr(addr1));
            switch (funcName) {
                case "urlquery.encode": {
                    String unquoted = arg1.substring(1, arg1.length() - 1);
                    try {
                        String result = arg1.charAt(0) + URLEncoder.encode(unquoted, "UTF-8") + arg1.charAt(arg1.length() - 1);
                        return this.loadJson(result).getInternal();
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            OPAModule.unsupportedFunction(builtinId, funcName);
            return 0;
        });
        this.builtin2 = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (builtinId, opaCtxReserved, addr1, addr2) -> {
            String funcName = this.getFuncName((int)builtinId);
            OPAModule.checkBuiltinFunctionExists(builtinId, funcName);
            OPAModule.unsupportedFunction(builtinId, funcName);
            return 0;
        });
        this.builtin3 = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (builtinId, opaCtxReserved, addr1, addr2, addr3) -> {
            String funcName = this.getFuncName((int)builtinId);
            OPAModule.checkBuiltinFunctionExists(builtinId, funcName);
            OPAModule.unsupportedFunction(builtinId, funcName);
            return 0;
        });
        this.builtin4 = WasmFunctions.wrap(this.store, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (WasmValType)WasmValType.I32, (builtinId, opaCtxReserved, addr1, addr2, addr3, addr4) -> {
            String funcName = this.getFuncName((int)builtinId);
            OPAModule.checkBuiltinFunctionExists(builtinId, funcName);
            OPAModule.unsupportedFunction(builtinId, funcName);
            return 0;
        });
        Extern opaabort = Extern.fromFunc((Func)this.abort);
        Extern opabuiltin0 = Extern.fromFunc((Func)this.builtin0);
        Extern opabuiltin1 = Extern.fromFunc((Func)this.builtin1);
        Extern opabuiltin2 = Extern.fromFunc((Func)this.builtin2);
        Extern opabuiltin3 = Extern.fromFunc((Func)this.builtin3);
        Extern opabuiltin4 = Extern.fromFunc((Func)this.builtin4);
        Extern opaprintln = Extern.fromFunc((Func)this.println);
        Extern opamemory = Extern.fromMemory((Memory)this.memory);
        this.linker.define(this.store, "env", "opa_abort", opaabort);
        this.linker.define(this.store, "env", "opa_builtin0", opabuiltin0);
        this.linker.define(this.store, "env", "opa_builtin1", opabuiltin1);
        this.linker.define(this.store, "env", "opa_builtin2", opabuiltin2);
        this.linker.define(this.store, "env", "opa_builtin3", opabuiltin3);
        this.linker.define(this.store, "env", "opa_builtin4", opabuiltin4);
        this.linker.define(this.store, "env", "opa_println", opaprintln);
        this.linker.define(this.store, "env", "memory", opamemory);
    }

    private static void checkBuiltinFunctionExists(Integer builtinId, String funcName) {
        if (funcName == null) {
            throw new UnsupportedOperationException("builtin function builtinId=" + builtinId + " not supported");
        }
    }

    private static void unsupportedFunction(Integer builtinId, String funcName) {
        throw new UnsupportedOperationException("builtin function '" + funcName + "', builtinId=" + builtinId + " not supported");
    }

    private void disposeImports() {
        if (this.memory != null) {
            this.memory.dispose();
            this.memory = null;
        }
        if (this.builtin0 != null) {
            this.builtin0.dispose();
            this.builtin0 = null;
        }
        if (this.builtin1 != null) {
            this.builtin1.dispose();
            this.builtin1 = null;
        }
        if (this.builtin2 != null) {
            this.builtin2.dispose();
            this.builtin2 = null;
        }
        if (this.builtin3 != null) {
            this.builtin3.dispose();
            this.builtin3 = null;
        }
        if (this.builtin4 != null) {
            this.builtin4.dispose();
            this.builtin4 = null;
        }
        if (this.println != null) {
            this.println.dispose();
            this.println = null;
        }
        if (this.abort != null) {
            this.abort.dispose();
            this.abort = null;
        }
    }

    protected void dispose(boolean disposing) {
        if (disposing) {
            if (this.module != null) {
                this.module.dispose();
                this.module = null;
            }
            if (this.wasi != null) {
                this.wasi.dispose();
                this.wasi = null;
            }
            if (this.linker != null) {
                this.linker.dispose();
                this.linker = null;
            }
            if (this.store != null) {
                this.store.dispose();
                this.store = null;
            }
            this.disposeImports();
        }
    }

    public Integer getAbiMajorVersion() {
        return this.exports.getAbiMajorVersion();
    }

    public Integer getAbiMinorVersion() {
        return this.exports.getAbiMinorVersion();
    }
}

