/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.sangcomz.fishbun.define.Define;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CameraUtil {
    private String savePath;

    public void takePicture(Activity activity, String saveDir) {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
            File photoFile = null;
            try {
                photoFile = this.createImageFile(saveDir);
                this.setSavePath(photoFile.getAbsolutePath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (photoFile != null) {
                Uri uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)activity, (String)(activity.getApplicationContext().getPackageName() + ".fishbunfileprovider"), (File)photoFile) : Uri.fromFile((File)photoFile);
                takePictureIntent.putExtra("output", (Parcelable)uri);
                activity.startActivityForResult(takePictureIntent, new Define().TAKE_A_PICK_REQUEST_CODE);
            }
        }
    }

    private File createImageFile(String saveDir) throws IOException {
        File dir = new File(saveDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File storageDir = new File(saveDir);
        return File.createTempFile(imageFileName, ".jpg", storageDir);
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }
}

