/*
 * Decompiled with CFR 0.152.
 */
package com.sangcomz.fishbun.ui.picker;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import com.sangcomz.fishbun.MimeType;
import com.sangcomz.fishbun.ext.MimeTypeExt;
import com.sangcomz.fishbun.permission.PermissionCheck;
import com.sangcomz.fishbun.ui.picker.PickerActivity;
import com.sangcomz.fishbun.util.CameraUtil;
import java.util.ArrayList;
import java.util.List;

public class PickerController {
    private PickerActivity pickerActivity;
    private ArrayList<Uri> addImagePaths = new ArrayList();
    private ContentResolver resolver;
    private CameraUtil cameraUtil = new CameraUtil();
    private String pathDir = "";

    PickerController(PickerActivity pickerActivity) {
        this.pickerActivity = pickerActivity;
        this.resolver = pickerActivity.getContentResolver();
    }

    public void takePicture(Activity activity, String saveDir) {
        this.cameraUtil.takePicture(activity, saveDir);
    }

    public void setToolbarTitle(int total) {
        this.pickerActivity.showToolbarTitle(total);
    }

    String getSavePath() {
        return this.cameraUtil.getSavePath();
    }

    void setSavePath(String savePath) {
        this.cameraUtil.setSavePath(savePath);
    }

    public void setAddImagePath(Uri imagePath) {
        this.addImagePaths.add(imagePath);
    }

    protected ArrayList<Uri> getAddImagePaths() {
        return this.addImagePaths;
    }

    public void setAddImagePaths(ArrayList<Uri> addImagePaths) {
        this.addImagePaths = addImagePaths;
    }

    boolean checkPermission() {
        PermissionCheck permissionCheck = new PermissionCheck((Context)this.pickerActivity);
        if (Build.VERSION.SDK_INT >= 23) {
            return permissionCheck.CheckStoragePermission();
        }
        return true;
    }

    public boolean checkCameraPermission() {
        PermissionCheck permissionCheck = new PermissionCheck((Context)this.pickerActivity);
        if (Build.VERSION.SDK_INT >= 23) {
            return permissionCheck.CheckCameraPermission();
        }
        return true;
    }

    void displayImage(Long bucketId, List<MimeType> exceptMimeType, List<String> specifyFolderList) {
        new DisplayImage(bucketId, exceptMimeType, specifyFolderList).execute(new Void[0]);
    }

    @NonNull
    private List<Uri> getAllMediaThumbnailsPath(long id2, List<MimeType> exceptMimeTypeList, List<String> specifyFolderList) {
        ArrayList<Uri> imageUris;
        block5: {
            String selection = "bucket_id = ?";
            String bucketId = String.valueOf(id2);
            String sort = "_id DESC";
            String[] selectionArgs = new String[]{bucketId};
            Uri images = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            Cursor c = !bucketId.equals("0") ? this.resolver.query(images, null, selection, selectionArgs, sort) : this.resolver.query(images, null, null, null, sort);
            imageUris = new ArrayList<Uri>();
            if (c != null) {
                try {
                    if (c.moveToFirst()) {
                        this.setPathDir(c.getString(c.getColumnIndex("_data")), c.getString(c.getColumnIndex("_display_name")));
                        do {
                            String mimeType = c.getString(c.getColumnIndex("mime_type"));
                            String folderName = c.getString(c.getColumnIndex("bucket_display_name"));
                            if (this.isExceptMemeType(exceptMimeTypeList, mimeType) || this.isNotContainsSpecifyFolderList(specifyFolderList, folderName)) continue;
                            int imgId = c.getInt(c.getColumnIndex("_id"));
                            Uri path = Uri.withAppendedPath((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (String)("" + imgId));
                            imageUris.add(path);
                        } while (c.moveToNext());
                    }
                    c.close();
                }
                catch (Exception e) {
                    if (c.isClosed()) break block5;
                    c.close();
                }
            }
        }
        return imageUris;
    }

    private void setPathDir(String path, String fileName) {
        this.pathDir = path.replace("/" + fileName, "");
    }

    String getPathDir(Long bucketId) {
        if (this.pathDir.equals("") || bucketId == 0L) {
            this.pathDir = Environment.getExternalStoragePublicDirectory((String)(Environment.DIRECTORY_DCIM + "/Camera")).getAbsolutePath();
        }
        return this.pathDir;
    }

    public void finishActivity() {
        this.pickerActivity.finishActivity();
    }

    private boolean isExceptMemeType(List<MimeType> mimeTypes, String mimeType) {
        for (MimeType type : mimeTypes) {
            if (!MimeTypeExt.equalsMimeType(type, mimeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isNotContainsSpecifyFolderList(List<String> specifyFolderList, String displayBundleName) {
        if (specifyFolderList.isEmpty()) {
            return false;
        }
        return !specifyFolderList.contains(displayBundleName);
    }

    private class DisplayImage
    extends AsyncTask<Void, Void, List<Uri>> {
        private Long bucketId;
        List<MimeType> exceptMimeType;
        List<String> specifyFolderList;

        DisplayImage(Long bucketId, List<MimeType> exceptMimeType, List<String> specifyFolderList) {
            this.bucketId = bucketId;
            this.exceptMimeType = exceptMimeType;
            this.specifyFolderList = specifyFolderList;
        }

        protected List<Uri> doInBackground(Void ... params) {
            return PickerController.this.getAllMediaThumbnailsPath(this.bucketId, this.exceptMimeType, this.specifyFolderList);
        }

        protected void onPostExecute(List<Uri> result) {
            super.onPostExecute(result);
            PickerController.this.pickerActivity.setAdapter(result);
        }
    }
}

