/*
 * Decompiled with CFR 0.152.
 */
package io.github.sac;

import com.neovisionaries.ws.client.OpeningHandshakeException;
import com.neovisionaries.ws.client.StatusLine;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import com.neovisionaries.ws.client.WebSocketFrame;
import com.neovisionaries.ws.client.WebSocketListener;
import com.neovisionaries.ws.client.WebSocketState;
import io.github.sac.Ack;
import io.github.sac.BasicListener;
import io.github.sac.Emitter;
import io.github.sac.EventThread;
import io.github.sac.Parser;
import io.github.sac.ReconnectStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Socket
extends Emitter {
    private final Logger logger = Logger.getLogger(Socket.class.getName());
    private AtomicInteger counter;
    private String URL;
    private WebSocketFactory factory;
    private ReconnectStrategy strategy;
    private WebSocket ws;
    private BasicListener listener;
    private String AuthToken;
    private HashMap<Long, Object[]> acks;
    private List<Channel> channels;
    private WebSocketAdapter adapter;
    private Map<String, String> headers;

    public Socket(String URL2) {
        this.URL = URL2;
        this.factory = new WebSocketFactory().setConnectionTimeout(5000);
        this.counter = new AtomicInteger(1);
        this.acks = new HashMap();
        this.channels = new ArrayList<Channel>();
        this.adapter = this.getAdapter();
        this.headers = new HashMap<String, String>();
        this.putDefaultHeaders();
    }

    private void putDefaultHeaders() {
        this.headers.put("Accept-Encoding", "gzip, deflate, sdch");
        this.headers.put("Accept-Language", "en-US,en;q=0.8");
        this.headers.put("Pragma", "no-cache");
        this.headers.put("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.87 Safari/537.36");
    }

    public Channel createChannel(String name) {
        Channel channel = new Channel(name);
        this.channels.add(channel);
        return channel;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public Channel getChannelByName(String name) {
        for (Channel channel : this.channels) {
            if (!channel.getChannelName().equals(name)) continue;
            return channel;
        }
        return null;
    }

    public void seturl(String url) {
        this.URL = url;
    }

    public void setReconnection(ReconnectStrategy strategy) {
        this.strategy = strategy;
    }

    public void setListener(BasicListener listener) {
        this.listener = listener;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public WebSocketFactory getFactorySettings() {
        return this.factory;
    }

    public void setAuthToken(String token) {
        this.AuthToken = token;
    }

    public WebSocketAdapter getAdapter() {
        return new WebSocketAdapter(){

            public void onConnected(WebSocket websocket, Map<String, List<String>> headers) throws Exception {
                Socket.this.counter.set(1);
                if (Socket.this.strategy != null) {
                    Socket.this.strategy.setAttemptsMade(0);
                }
                JSONObject handshakeObject = new JSONObject();
                handshakeObject.put("event", (Object)"#handshake");
                JSONObject object = new JSONObject();
                object.put("authToken", (Object)Socket.this.AuthToken);
                handshakeObject.put("data", (Object)object);
                handshakeObject.put("cid", Socket.this.counter.getAndIncrement());
                websocket.sendText(handshakeObject.toString());
                Socket.this.listener.onConnected(Socket.this, headers);
                super.onConnected(websocket, headers);
            }

            public void onDisconnected(WebSocket websocket, WebSocketFrame serverCloseFrame, WebSocketFrame clientCloseFrame, boolean closedByServer) throws Exception {
                Socket.this.listener.onDisconnected(Socket.this, serverCloseFrame, clientCloseFrame, closedByServer);
                Socket.this.reconnect();
                super.onDisconnected(websocket, serverCloseFrame, clientCloseFrame, closedByServer);
            }

            public void onConnectError(WebSocket websocket, WebSocketException exception) throws Exception {
                Socket.this.listener.onConnectError(Socket.this, exception);
                Socket.this.reconnect();
                super.onConnectError(websocket, exception);
            }

            public void onFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                if (frame.getPayloadText().equalsIgnoreCase("#1")) {
                    websocket.sendText("#2");
                } else {
                    JSONObject object = new JSONObject(frame.getPayloadText());
                    Socket.this.logger.info("Message :" + object.toString());
                    try {
                        Object dataobject = object.opt("data");
                        Integer rid = (Integer)object.opt("rid");
                        Integer cid = (Integer)object.opt("cid");
                        String event = (String)object.opt("event");
                        switch (Parser.parse(dataobject, event)) {
                            case ISAUTHENTICATED: {
                                Socket.this.listener.onAuthentication(Socket.this, ((JSONObject)dataobject).getBoolean("isAuthenticated"));
                                Socket.this.subscribeChannels();
                                break;
                            }
                            case PUBLISH: {
                                Socket.this.handlePublish(((JSONObject)dataobject).getString("channel"), ((JSONObject)dataobject).opt("data"));
                                break;
                            }
                            case REMOVETOKEN: {
                                Socket.this.setAuthToken(null);
                                break;
                            }
                            case SETTOKEN: {
                                String token = ((JSONObject)dataobject).getString("token");
                                Socket.this.setAuthToken(token);
                                Socket.this.listener.onSetAuthToken(token, Socket.this);
                                break;
                            }
                            case EVENT: {
                                if (Socket.this.hasEventAck(event)) {
                                    Socket.this.handleEmitAck(event, dataobject, Socket.this.ack((long)cid));
                                    break;
                                }
                                Socket.this.handleEmit(event, dataobject);
                                break;
                            }
                            case ACKRECEIVE: {
                                Object[] objects;
                                if (!Socket.this.acks.containsKey(rid) || (objects = (Object[])Socket.this.acks.remove(rid)) == null) break;
                                Ack fn = (Ack)objects[1];
                                if (fn != null) {
                                    fn.call((String)objects[0], object.opt("error"), object.opt("data"));
                                    break;
                                }
                                Socket.this.logger.warning("ack function is null with rid " + rid);
                            }
                        }
                    }
                    catch (Exception e) {
                        Socket.this.logger.severe(e.toString());
                    }
                }
                super.onFrame(websocket, frame);
            }

            public void onCloseFrame(WebSocket websocket, WebSocketFrame frame) throws Exception {
                Socket.this.logger.warning("On close frame got called");
                super.onCloseFrame(websocket, frame);
            }

            public void onSendError(WebSocket websocket, WebSocketException cause, WebSocketFrame frame) throws Exception {
                Socket.this.logger.severe("Error while sending data " + cause.toString());
                super.onSendError(websocket, cause, frame);
            }
        };
    }

    public Socket emit(final String event, final Object object) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject eventObject = new JSONObject();
                try {
                    eventObject.put("event", (Object)event);
                    eventObject.put("data", object);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(eventObject.toString());
            }
        });
        return this;
    }

    public Socket emit(final String event, final Object object, final Ack ack) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject eventObject = new JSONObject();
                Socket.this.acks.put(Socket.this.counter.longValue(), Socket.this.getAckObject(event, ack));
                try {
                    eventObject.put("event", (Object)event);
                    eventObject.put("data", object);
                    eventObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(eventObject.toString());
            }
        });
        return this;
    }

    private Socket subscribe(final String channel) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject subscribeObject = new JSONObject();
                try {
                    subscribeObject.put("event", (Object)"#subscribe");
                    JSONObject object = new JSONObject();
                    object.put("channel", (Object)channel);
                    subscribeObject.put("data", (Object)object);
                    subscribeObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(subscribeObject.toString());
            }
        });
        return this;
    }

    private Object[] getAckObject(String event, Ack ack) {
        Object[] object = new Object[]{event, ack};
        return object;
    }

    private Socket subscribe(final String channel, final Ack ack) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject subscribeObject = new JSONObject();
                try {
                    subscribeObject.put("event", (Object)"#subscribe");
                    JSONObject object = new JSONObject();
                    Socket.this.acks.put(Socket.this.counter.longValue(), Socket.this.getAckObject(channel, ack));
                    object.put("channel", (Object)channel);
                    subscribeObject.put("data", (Object)object);
                    subscribeObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(subscribeObject.toString());
            }
        });
        return this;
    }

    private Socket unsubscribe(final String channel) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject subscribeObject = new JSONObject();
                try {
                    subscribeObject.put("event", (Object)"#unsubscribe");
                    subscribeObject.put("data", (Object)channel);
                    subscribeObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(subscribeObject.toString());
            }
        });
        return this;
    }

    private Socket unsubscribe(final String channel, final Ack ack) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject subscribeObject = new JSONObject();
                try {
                    subscribeObject.put("event", (Object)"#unsubscribe");
                    subscribeObject.put("data", (Object)channel);
                    Socket.this.acks.put(Socket.this.counter.longValue(), Socket.this.getAckObject(channel, ack));
                    subscribeObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(subscribeObject.toString());
            }
        });
        return this;
    }

    public Socket publish(final String channel, final Object data) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject publishObject = new JSONObject();
                try {
                    publishObject.put("event", (Object)"#publish");
                    JSONObject object = new JSONObject();
                    object.put("channel", (Object)channel);
                    object.put("data", data);
                    publishObject.put("data", (Object)object);
                    publishObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(publishObject.toString());
            }
        });
        return this;
    }

    public Socket publish(final String channel, final Object data, final Ack ack) {
        EventThread.exec(new Runnable(){

            @Override
            public void run() {
                JSONObject publishObject = new JSONObject();
                try {
                    publishObject.put("event", (Object)"#publish");
                    JSONObject object = new JSONObject();
                    Socket.this.acks.put(Socket.this.counter.longValue(), Socket.this.getAckObject(channel, ack));
                    object.put("channel", (Object)channel);
                    object.put("data", data);
                    publishObject.put("data", (Object)object);
                    publishObject.put("cid", Socket.this.counter.getAndIncrement());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Socket.this.ws.sendText(publishObject.toString());
            }
        });
        return this;
    }

    private Ack ack(final Long cid) {
        return new Ack(){

            @Override
            public void call(String channel, final Object error, final Object data) {
                EventThread.exec(new Runnable(){

                    @Override
                    public void run() {
                        JSONObject object = new JSONObject();
                        try {
                            object.put("error", error);
                            object.put("data", data);
                            object.put("rid", (Object)cid);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        Socket.this.ws.sendText(object.toString());
                    }
                });
            }
        };
    }

    private void subscribeChannels() {
        for (Channel channel : this.channels) {
            channel.subscribe();
        }
    }

    public void setExtraHeaders(Map<String, String> extraHeaders, boolean overrideDefaultHeaders) {
        if (overrideDefaultHeaders) {
            this.headers.clear();
        }
        this.headers.putAll(extraHeaders);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void connect() {
        try {
            this.ws = this.factory.createSocket(this.URL);
        }
        catch (IOException e) {
            this.logger.severe(e.toString());
        }
        this.ws.addExtension("permessage-deflate; client_max_window_bits");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            this.ws.addHeader(entry.getKey(), entry.getValue());
        }
        this.ws.addListener((WebSocketListener)this.adapter);
        try {
            this.ws.connect();
        }
        catch (OpeningHandshakeException e) {
            this.logger.severe(e.toString());
            StatusLine sl = e.getStatusLine();
            this.logger.info("=== Status Line ===");
            this.logger.info("HTTP Version  = \n" + sl.getHttpVersion());
            this.logger.info("Status Code   = \n" + sl.getStatusCode());
            this.logger.info("Reason Phrase = \n" + sl.getReasonPhrase());
            Map headers = e.getHeaders();
            this.logger.info("=== HTTP Headers ===");
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List values = (List)entry.getValue();
                if (values == null || values.size() == 0) {
                    this.logger.info(name);
                    continue;
                }
                for (String value : values) {
                    this.logger.info(name + value + "\n");
                }
            }
        }
        catch (WebSocketException e) {
            this.listener.onConnectError(this, e);
            this.reconnect();
        }
    }

    public void connectAsync() {
        try {
            this.ws = this.factory.createSocket(this.URL);
        }
        catch (IOException e) {
            this.logger.severe(e.toString());
        }
        this.ws.addExtension("permessage-deflate; client_max_window_bits");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            this.ws.addHeader(entry.getKey(), entry.getValue());
        }
        this.ws.addListener((WebSocketListener)this.adapter);
        this.ws.connectAsynchronously();
    }

    private void reconnect() {
        if (this.strategy == null) {
            this.logger.warning("Unable to reconnect: reconnection is null");
            return;
        }
        if (this.strategy.areAttemptsComplete()) {
            this.strategy.setAttemptsMade(0);
            this.logger.warning("Unable to reconnect: max reconnection attempts reached");
            return;
        }
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (Socket.this.strategy == null) {
                    Socket.this.logger.warning("Unable to reconnect: reconnection is null");
                    return;
                }
                Socket.this.strategy.processValues();
                Socket.this.connect();
                timer.cancel();
                timer.purge();
            }
        }, this.strategy.getReconnectInterval());
    }

    public void disconnect() {
        if (this.ws != null) {
            this.ws.disconnect();
        }
        this.strategy = null;
    }

    public WebSocketState getCurrentState() {
        return this.ws.getState();
    }

    public Boolean isconnected() {
        return this.ws != null && this.ws.getState() == WebSocketState.OPEN;
    }

    public void disableLogging() {
        this.logger.setLevel(Level.OFF);
    }

    protected void finalize() throws Throwable {
        this.ws.disconnect("Client socket garbage collected, closing connection");
        super.finalize();
    }

    public class Channel {
        String channelName;

        public String getChannelName() {
            return this.channelName;
        }

        public Channel(String channelName) {
            this.channelName = channelName;
        }

        public void subscribe() {
            Socket.this.subscribe(this.channelName);
        }

        public void subscribe(Ack ack) {
            Socket.this.subscribe(this.channelName, ack);
        }

        public void onMessage(Emitter.Listener listener) {
            Socket.this.onSubscribe(this.channelName, listener);
        }

        public void publish(Object data) {
            Socket.this.publish(this.channelName, data);
        }

        public void publish(Object data, Ack ack) {
            Socket.this.publish(this.channelName, data, ack);
        }

        public void unsubscribe() {
            Socket.this.unsubscribe(this.channelName);
            Socket.this.channels.remove(this);
        }

        public void unsubscribe(Ack ack) {
            Socket.this.unsubscribe(this.channelName, ack);
            Socket.this.channels.remove(this);
        }
    }
}

