/*
 * Decompiled with CFR 0.152.
 */
package io.github.sac;

import java.util.logging.Level;
import java.util.logging.Logger;

public class ReconnectStrategy {
    private static final Logger LOGGER = Logger.getLogger(ReconnectStrategy.class.getName());
    int reconnectInterval;
    int maxReconnectInterval;
    float reconnectDecay;
    Integer maxAttempts;
    Integer attemptsMade;

    public ReconnectStrategy() {
        LOGGER.setLevel(Level.INFO);
        this.reconnectInterval = 2000;
        this.maxReconnectInterval = 30000;
        this.reconnectDecay = 1.0f;
        this.maxAttempts = null;
        this.attemptsMade = 0;
    }

    public ReconnectStrategy setMaxAttempts(Integer maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public ReconnectStrategy setDelay(int delay) {
        this.reconnectInterval = delay;
        return this;
    }

    public void setAttemptsMade(Integer attemptsMade) {
        this.attemptsMade = attemptsMade;
    }

    public ReconnectStrategy(int reconnectInterval, int maxReconnectInterval, float reconnectDecay, int maxAttempts) {
        this.reconnectInterval = reconnectInterval > maxReconnectInterval ? maxReconnectInterval : reconnectInterval;
        this.maxReconnectInterval = maxReconnectInterval;
        this.reconnectDecay = reconnectDecay;
        this.maxAttempts = maxAttempts;
        this.attemptsMade = 0;
    }

    public void processValues() {
        Integer n = this.attemptsMade;
        Integer n2 = this.attemptsMade = Integer.valueOf(this.attemptsMade + 1);
        LOGGER.info("Attempt number :" + this.attemptsMade);
        if (this.reconnectInterval < this.maxReconnectInterval) {
            this.reconnectInterval = (int)((float)this.reconnectInterval * this.reconnectDecay);
            if (this.reconnectInterval > this.maxReconnectInterval) {
                this.reconnectInterval = this.maxReconnectInterval;
            }
        }
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public boolean areAttemptsComplete() {
        return this.attemptsMade.equals(this.maxAttempts);
    }
}

