/*
 * Decompiled with CFR 0.152.
 */
package io.github.sac;

import io.github.sac.Ack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Emitter {
    private ConcurrentHashMap<String, Listener> singlecallbacks = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AckListener> singleackcallbacks = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Listener> publishcallbacks = new ConcurrentHashMap();

    public Emitter on(String event, Listener fn) {
        if (this.singlecallbacks.containsKey(event)) {
            this.singlecallbacks.remove(event);
        }
        this.singlecallbacks.put(event, fn);
        return this;
    }

    public Emitter onSubscribe(String event, Listener fn) {
        if (this.publishcallbacks.containsKey(event)) {
            this.publishcallbacks.remove(event);
        }
        this.publishcallbacks.put(event, fn);
        return this;
    }

    public Emitter on(String event, AckListener fn) {
        if (this.singleackcallbacks.containsKey(event)) {
            this.singleackcallbacks.remove(event);
        }
        this.singleackcallbacks.put(event, fn);
        return this;
    }

    public Emitter handleEmit(String event, Object object) {
        Listener listener = this.singlecallbacks.get(event);
        if (listener != null) {
            listener.call(event, object);
        }
        return this;
    }

    public Emitter handlePublish(String event, Object object) {
        Listener listener = this.publishcallbacks.get(event);
        if (listener != null) {
            listener.call(event, object);
        }
        return this;
    }

    public boolean hasEventAck(String event) {
        return this.singleackcallbacks.get(event) != null;
    }

    public Emitter handleEmitAck(String event, Object object, Ack ack) {
        AckListener listener = this.singleackcallbacks.get(event);
        if (listener != null) {
            listener.call(event, object, ack);
        }
        return this;
    }

    public void removeEmitCallback(String event) {
        this.singlecallbacks.remove(event);
        this.singleackcallbacks.remove(event);
    }

    public void removeSubscribeCallback(String event) {
        this.publishcallbacks.remove(event);
    }

    public void removeAllCallbacks() {
        for (Map.Entry<String, Listener> entry : this.singlecallbacks.entrySet()) {
            this.singlecallbacks.remove(entry.getKey().toString());
        }
        for (Map.Entry<String, Object> entry : this.singleackcallbacks.entrySet()) {
            this.singleackcallbacks.remove(entry.getKey().toString());
        }
        for (Map.Entry<String, Object> entry : this.publishcallbacks.entrySet()) {
            this.publishcallbacks.remove(entry.getKey().toString());
        }
    }

    public static interface AckListener {
        public void call(String var1, Object var2, Ack var3);
    }

    public static interface Listener {
        public void call(String var1, Object var2);
    }
}

