/*
 * Decompiled with CFR 0.152.
 */
package route250.unixdomainsocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.net.UnixDomainSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.net.SocketFactory;

public final class UnixDomainSocketFactory
extends SocketFactory {
    private static Set<String> sLocalHosts = new HashSet<String>();
    private static List<InetAddress> sLocalAddress = new ArrayList<InetAddress>();
    private static long sLocalAddressReloadTime;
    private final Function<Integer, Path> mToPath;
    private Map<Integer, UnixDomainSocketAddress> mPortToSocketAddress = new LinkedHashMap<Integer, UnixDomainSocketAddress>();
    private static final UnixDomainSocketAddress SOCKET_FILE_NOT_EXISTS;
    private long mSocketAddressReloadTime;

    public UnixDomainSocketFactory(Function<Integer, Path> aToPath) {
        this.mToPath = aToPath;
    }

    public static boolean isLocal(String aHost) {
        UnixDomainSocketFactory.reloadLocalAddress(System.currentTimeMillis());
        if (sLocalHosts.contains(aHost)) {
            return true;
        }
        try {
            return UnixDomainSocketFactory.isLocal(InetAddress.getByName(aHost));
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isLocal(InetAddress aHost) {
        for (InetAddress u : sLocalAddress) {
            if (!u.equals(aHost)) continue;
            return true;
        }
        return false;
    }

    public static void reloadLocalAddress(long zNow) {
        if (zNow >= sLocalAddressReloadTime + 5000L) {
            sLocalAddressReloadTime = zNow;
            HashSet<String> zHosts = new HashSet<String>();
            ArrayList<InetAddress> zList = new ArrayList<InetAddress>();
            try {
                NetworkInterface.networkInterfaces().forEach(eth -> eth.inetAddresses().forEach(x -> zList.add((InetAddress)x)));
                for (InetAddress a : zList) {
                    zHosts.add(a.getCanonicalHostName());
                    zHosts.add(a.getHostName());
                    zHosts.add(a.getHostAddress());
                }
                sLocalHosts = zHosts;
                sLocalAddress = zList;
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    private void reloadSocketAddress() {
        long zNow = System.currentTimeMillis();
        UnixDomainSocketFactory.reloadLocalAddress(zNow);
        if (zNow >= this.mSocketAddressReloadTime + 1000L) {
            this.mSocketAddressReloadTime = zNow;
            this.mPortToSocketAddress = new LinkedHashMap<Integer, UnixDomainSocketAddress>();
        }
    }

    private UnixDomainSocketAddress toSocketPath(String aHost, Integer aPort) throws UnknownHostException, NoRouteToHostException, PortUnreachableException {
        this.reloadSocketAddress();
        if (!sLocalHosts.contains(aHost)) {
            return this.toSocketPath(InetAddress.getByName(aHost), aPort);
        }
        return this.toSocketPath(aPort);
    }

    private UnixDomainSocketAddress toSocketPath(InetAddress aHost, Integer aPort) throws NoRouteToHostException, PortUnreachableException {
        this.reloadSocketAddress();
        boolean exists = false;
        for (InetAddress u : sLocalAddress) {
            if (!u.equals(aHost)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            throw new NoRouteToHostException(aHost.getHostAddress());
        }
        return this.toSocketPath(aPort);
    }

    private UnixDomainSocketAddress toSocketPath(Integer aPort) throws PortUnreachableException {
        UnixDomainSocketAddress zAddress = this.mPortToSocketAddress.get(aPort);
        if (zAddress == null) {
            Path zPath = this.toPath(aPort);
            zAddress = !Files.exists(zPath, new LinkOption[0]) || Files.isDirectory(zPath, new LinkOption[0]) || Files.isRegularFile(zPath, new LinkOption[0]) ? SOCKET_FILE_NOT_EXISTS : UnixDomainSocketAddress.of(zPath);
            this.mPortToSocketAddress.put(aPort, zAddress);
        }
        if (zAddress == SOCKET_FILE_NOT_EXISTS) {
            throw new PortUnreachableException("" + aPort);
        }
        return zAddress;
    }

    private Path toPath(Integer aPort) throws PortUnreachableException {
        try {
            return this.mToPath.apply(aPort);
        }
        catch (Error | Exception ex) {
            String zMesg = ex.getMessage() != null ? " " + ex.getMessage() : "";
            throw new PortUnreachableException("port " + aPort + zMesg);
        }
    }

    @Override
    public Socket createSocket(String aHost, int aPort) throws IOException, UnknownHostException {
        return new UnixDomainSocket(aHost, (Integer)aPort);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Socket createSocket(InetAddress aHost, int aPort) throws IOException {
        return new UnixDomainSocket(aHost, (Integer)aPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        SOCKET_FILE_NOT_EXISTS = UnixDomainSocketAddress.of(Paths.get("/", new String[0]));
    }

    public class UnixDomainSocket
    extends Socket {
        final UnixDomainSocketImpl mImpl;

        public UnixDomainSocket(String aHost, Integer aPort) throws SocketException, IOException {
            this(this$0.new UnixDomainSocketImpl(aHost, aPort));
        }

        public UnixDomainSocket(InetAddress aHost, Integer aPort) throws SocketException, IOException {
            this(this$0.new UnixDomainSocketImpl(aHost, aPort));
        }

        private UnixDomainSocket(UnixDomainSocketImpl impl) throws SocketException {
            super(impl);
            this.mImpl = impl;
        }
    }

    public class UnixDomainSocketImpl
    extends SocketImpl {
        SocketChannel mSocketChannel;

        public UnixDomainSocketImpl(String aHost, Integer aPort) throws IOException, UnknownHostException {
            UnixDomainSocketFactory.this.toSocketPath(aHost, aPort);
        }

        public UnixDomainSocketImpl(InetAddress aHost, Integer aPort) throws IOException, UnknownHostException {
            UnixDomainSocketFactory.this.toSocketPath(aHost, aPort);
        }

        @Override
        protected void create(boolean stream) throws IOException {
            if (!stream) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            this.mSocketChannel = SocketChannel.open(StandardProtocolFamily.UNIX);
        }

        @Override
        protected void connect(String aHost, int aPort) throws IOException {
            UnixDomainSocketAddress zPath = UnixDomainSocketFactory.this.toSocketPath(aHost, (Integer)aPort);
            this.port = aPort;
            this.mSocketChannel.connect(zPath);
        }

        @Override
        protected void connect(InetAddress aHost, int aPort) throws IOException {
            UnixDomainSocketAddress zPath = UnixDomainSocketFactory.this.toSocketPath(aHost, (Integer)aPort);
            this.port = aPort;
            this.mSocketChannel.connect(zPath);
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void listen(int backlog) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            return Channels.newInputStream(this.mSocketChannel);
        }

        @Override
        protected void shutdownInput() throws IOException {
            this.mSocketChannel.shutdownInput();
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            return Channels.newOutputStream(this.mSocketChannel);
        }

        @Override
        protected void shutdownOutput() throws IOException {
            this.mSocketChannel.shutdownOutput();
        }

        @Override
        protected int available() throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void close() throws IOException {
            this.mSocketChannel.close();
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        private static SocketOption opt(int optID) throws SocketException {
            switch (optID) {
                case 4098: {
                    return StandardSocketOptions.SO_RCVBUF;
                }
                case 4097: {
                    return StandardSocketOptions.SO_SNDBUF;
                }
                case 128: {
                    return StandardSocketOptions.SO_LINGER;
                }
                case 4: {
                    return StandardSocketOptions.SO_REUSEADDR;
                }
                case 14: {
                    return StandardSocketOptions.SO_REUSEPORT;
                }
                case 8: {
                    return StandardSocketOptions.SO_KEEPALIVE;
                }
                case 1: {
                    return StandardSocketOptions.TCP_NODELAY;
                }
                case 3: {
                    return StandardSocketOptions.IP_TOS;
                }
                case 4099: {
                    throw new UnsupportedOperationException("'SO_OOBINLINE' not supported");
                }
                case 4102: {
                    throw new UnsupportedOperationException("'SO_TIMEOUT' not supported");
                }
                case 15: {
                    throw new UnsupportedOperationException("'SO_BINDADDR' not supported");
                }
            }
            throw new UnsupportedOperationException("#" + optID + " not supported");
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            try {
                this.mSocketChannel.setOption(UnixDomainSocketImpl.opt(optID), value);
            }
            catch (IOException | UnsupportedOperationException ex) {
                throw new SocketException(ex.getMessage());
            }
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            try {
                return this.mSocketChannel.getOption(UnixDomainSocketImpl.opt(optID));
            }
            catch (IOException | UnsupportedOperationException ex) {
                throw new SocketException(ex.getMessage());
            }
        }

        @Override
        protected Set<SocketOption<?>> supportedOptions() {
            return this.mSocketChannel.supportedOptions();
        }
    }
}

