/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.GroupBy;
import io.github.robwin.swagger2markup.Language;
import io.github.robwin.swagger2markup.OrderBy;
import io.github.robwin.swagger2markup.builder.document.DefinitionsDocument;
import io.github.robwin.swagger2markup.builder.document.OverviewDocument;
import io.github.robwin.swagger2markup.builder.document.PathsDocument;
import io.github.robwin.swagger2markup.config.Swagger2MarkupConfig;
import io.github.robwin.swagger2markup.utils.Consumer;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swagger2MarkupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(Swagger2MarkupConverter.class);
    private final Swagger2MarkupConfig swagger2MarkupConfig;
    private static final String OVERVIEW_DOCUMENT = "overview";
    private static final String PATHS_DOCUMENT = "paths";
    private static final String DEFINITIONS_DOCUMENT = "definitions";

    Swagger2MarkupConverter(Swagger2MarkupConfig swagger2MarkupConfig) {
        this.swagger2MarkupConfig = swagger2MarkupConfig;
    }

    public static Builder from(String swaggerLocation) {
        Validate.notEmpty((CharSequence)swaggerLocation, (String)"swaggerLocation must not be empty!", (Object[])new Object[0]);
        return new Builder(swaggerLocation);
    }

    public static Builder from(Swagger swagger) {
        Validate.notNull((Object)swagger, (String)"Swagger must not be null!", (Object[])new Object[0]);
        return new Builder(swagger);
    }

    public static Builder fromString(String swaggerAsString) throws IOException {
        Validate.notEmpty((CharSequence)swaggerAsString, (String)"Swagger String must not be null!", (Object[])new Object[0]);
        Swagger swagger = new SwaggerParser().parse(swaggerAsString);
        if (swagger == null) {
            throw new IllegalArgumentException("Swagger String is in the wrong format");
        }
        return new Builder(swagger);
    }

    public void intoFolder(String targetFolderPath) throws IOException {
        Validate.notEmpty((CharSequence)targetFolderPath, (String)"folderPath must not be null!", (Object[])new Object[0]);
        this.buildDocuments(targetFolderPath);
    }

    public String asString() throws IOException {
        return this.buildDocuments();
    }

    private void buildDocuments(String directory) throws IOException {
        new OverviewDocument(this.swagger2MarkupConfig).build().writeToFile(directory, OVERVIEW_DOCUMENT, StandardCharsets.UTF_8);
        new PathsDocument(this.swagger2MarkupConfig).build().writeToFile(directory, PATHS_DOCUMENT, StandardCharsets.UTF_8);
        new DefinitionsDocument(this.swagger2MarkupConfig, directory).build().writeToFile(directory, DEFINITIONS_DOCUMENT, StandardCharsets.UTF_8);
    }

    private String buildDocuments() {
        return new OverviewDocument(this.swagger2MarkupConfig).build().toString().concat(new PathsDocument(this.swagger2MarkupConfig).build().toString().concat(new DefinitionsDocument(this.swagger2MarkupConfig, null).build().toString()));
    }

    public static class Builder {
        private final Swagger swagger;
        private String examplesFolderPath;
        private String schemasFolderPath;
        private String descriptionsFolderPath;
        private boolean separatedDefinitions;
        private GroupBy pathsGroupedBy = GroupBy.AS_IS;
        private OrderBy definitionsOrderedBy = OrderBy.NATURAL;
        private MarkupLanguage markupLanguage = MarkupLanguage.ASCIIDOC;
        private Language outputLanguage = Language.EN;

        Builder(String swaggerLocation) {
            this.swagger = new SwaggerParser().read(swaggerLocation);
            if (this.swagger == null) {
                throw new IllegalArgumentException("Failed to read the Swagger file. ");
            }
        }

        Builder(Swagger swagger) {
            this.swagger = swagger;
        }

        public Swagger2MarkupConverter build() {
            return new Swagger2MarkupConverter(new Swagger2MarkupConfig(this.swagger, this.markupLanguage, this.examplesFolderPath, this.schemasFolderPath, this.descriptionsFolderPath, this.separatedDefinitions, this.pathsGroupedBy, this.definitionsOrderedBy, this.outputLanguage));
        }

        public Builder withMarkupLanguage(MarkupLanguage markupLanguage) {
            this.markupLanguage = markupLanguage;
            return this;
        }

        public Builder withDescriptions(String descriptionsFolderPath) {
            this.descriptionsFolderPath = descriptionsFolderPath;
            return this;
        }

        public Builder withSeparatedDefinitions() {
            this.separatedDefinitions = true;
            return this;
        }

        public Builder withExamples(String examplesFolderPath) {
            this.examplesFolderPath = examplesFolderPath;
            return this;
        }

        public Builder withSchemas(String schemasFolderPath) {
            this.schemasFolderPath = schemasFolderPath;
            return this;
        }

        public Builder preProcessSwagger(Consumer<Swagger> preProcessor) {
            preProcessor.accept(this.swagger);
            return this;
        }

        public Builder withPathsGroupedBy(GroupBy pathsGroupedBy) {
            this.pathsGroupedBy = pathsGroupedBy;
            return this;
        }

        public Builder withDefinitionsOrderedBy(OrderBy definitionsOrderedBy) {
            this.definitionsOrderedBy = definitionsOrderedBy;
            return this;
        }

        public Builder withOutputLanguage(Language language) {
            this.outputLanguage = language;
            return this;
        }
    }
}

