/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.markup.builder.markdown;

import io.github.robwin.markup.builder.AbstractMarkupDocBuilder;
import io.github.robwin.markup.builder.MarkupDocBuilder;
import io.github.robwin.markup.builder.markdown.Markdown;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;

public class MarkdownBuilder
extends AbstractMarkupDocBuilder {
    @Override
    public MarkupDocBuilder documentTitle(String title) {
        this.documentTitle(Markdown.DOCUMENT_TITLE, title);
        return this;
    }

    @Override
    public MarkupDocBuilder documentTitleWithAttributes(String title) {
        this.documentTitle(Markdown.DOCUMENT_TITLE, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel1(String title) {
        this.sectionTitleLevel1(Markdown.SECTION_TITLE_LEVEL1, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel2(String title) {
        this.sectionTitleLevel2(Markdown.SECTION_TITLE_LEVEL2, title);
        return this;
    }

    @Override
    public MarkupDocBuilder sectionTitleLevel3(String title) {
        this.sectionTitleLevel3(Markdown.SECTION_TITLE_LEVEL3, title);
        return this;
    }

    @Override
    public MarkupDocBuilder paragraph(String text) {
        this.paragraph(Markdown.HARDBREAKS, text);
        return this;
    }

    @Override
    public MarkupDocBuilder listing(String text) {
        this.listing(Markdown.LISTING, text);
        return this;
    }

    @Override
    public MarkupDocBuilder source(String text, String language) {
        this.documentBuilder.append(Markdown.LISTING).append(language).append(this.newLine).append(text).append(this.newLine).append(Markdown.LISTING).append(this.newLine).append(this.newLine);
        return this;
    }

    @Override
    public MarkupDocBuilder boldTextLine(String text) {
        this.boldTextLine(Markdown.BOLD, text);
        return this;
    }

    @Override
    public MarkupDocBuilder italicTextLine(String text) {
        this.italicTextLine(Markdown.ITALIC, text);
        return this;
    }

    @Override
    public MarkupDocBuilder unorderedList(List<String> list) {
        this.unorderedList(Markdown.LIST_ENTRY, list);
        return this;
    }

    @Override
    public MarkupDocBuilder tableWithHeaderRow(List<String> rowsInPSV) {
        String headersInPSV = rowsInPSV.get(0);
        List<String> contentRowsInPSV = rowsInPSV.subList(1, rowsInPSV.size());
        String[] headersAsArray = headersInPSV.split(String.format("\\%s", Markdown.TABLE_COLUMN_DELIMITER.toString()));
        List<String> headers = Arrays.asList(headersAsArray);
        this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER.toString());
        this.documentBuilder.append(headersInPSV);
        this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER.toString());
        this.newLine();
        this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER.toString());
        for (String header : headers) {
            for (int i = 1; i < 5; ++i) {
                this.documentBuilder.append(Markdown.TABLE_ROW);
            }
            this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER.toString());
        }
        this.newLine();
        for (String contentRowInPSV : contentRowsInPSV) {
            this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER.toString());
            this.documentBuilder.append(contentRowInPSV);
            this.documentBuilder.append(Markdown.TABLE_COLUMN_DELIMITER.toString());
            this.newLine();
        }
        this.newLine().newLine();
        return this;
    }

    @Override
    public MarkupDocBuilder crossReference(String text) {
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void writeToFile(String directory, String fileName, Charset charset) throws IOException {
        String fileNameWithExtension = fileName + ".md";
        super.writeToFile(directory, fileNameWithExtension, charset);
    }
}

