/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.markup.builder;

import io.github.robwin.markup.builder.Markup;
import io.github.robwin.markup.builder.MarkupDocBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMarkupDocBuilder
implements MarkupDocBuilder {
    protected StringBuilder documentBuilder = new StringBuilder();
    protected String newLine = System.getProperty("line.separator");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void documentTitle(Markup markup, String title) {
        this.documentBuilder.append(markup).append(title).append(this.newLine).append(this.newLine);
    }

    protected void documentTitleWithAttributes(Markup markup, String title) {
        this.documentBuilder.append(markup).append(title).append(this.newLine);
    }

    protected void sectionTitleLevel1(Markup markup, String title) {
        this.documentBuilder.append(markup).append(title).append(this.newLine);
    }

    protected void sectionTitleLevel2(Markup markup, String title) {
        this.documentBuilder.append(markup).append(title).append(this.newLine);
    }

    protected void sectionTitleLevel3(Markup markup, String title) {
        this.documentBuilder.append(markup).append(title).append(this.newLine);
    }

    @Override
    public MarkupDocBuilder textLine(String text) {
        this.documentBuilder.append(text).append(this.newLine);
        return this;
    }

    protected void paragraph(Markup markup, String text) {
        this.documentBuilder.append(markup).append(this.newLine).append(text).append(this.newLine).append(this.newLine);
    }

    protected void listing(Markup markup, String text) {
        this.delimitedTextLine(markup, text);
    }

    protected void delimitedTextLine(Markup markup, String text) {
        this.documentBuilder.append(markup).append(this.newLine).append(text).append(this.newLine).append(markup).append(this.newLine).append(this.newLine);
    }

    protected void delimitedTextLineWithoutLineBreaks(Markup markup, String text) {
        this.documentBuilder.append(markup).append(text).append(markup).append(this.newLine);
    }

    protected void preserveLineBreaks(Markup markup) {
        this.documentBuilder.append(markup).append(this.newLine);
    }

    protected void boldTextLine(Markup markup, String text) {
        this.delimitedTextLineWithoutLineBreaks(markup, text);
    }

    protected void italicTextLine(Markup markup, String text) {
        this.delimitedTextLineWithoutLineBreaks(markup, text);
    }

    protected void unorderedList(Markup markup, List<String> list) {
        this.documentBuilder.append(this.newLine);
        for (String listEntry : list) {
            this.documentBuilder.append(markup).append(listEntry).append(this.newLine);
        }
        this.documentBuilder.append(this.newLine);
    }

    @Override
    public MarkupDocBuilder newLine() {
        this.documentBuilder.append(this.newLine);
        return this;
    }

    @Override
    public String toString() {
        return this.documentBuilder.toString();
    }

    @Override
    public void writeToFile(String directory, String fileNameWithExtension, Charset charset) throws IOException {
        Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(directory, fileNameWithExtension), charset, new OpenOption[0]);){
            writer.write(this.documentBuilder.toString());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} was written to: {}", (Object)fileNameWithExtension, (Object)directory);
        }
        this.documentBuilder = new StringBuilder();
    }
}

