/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger.test;

import io.github.robwin.swagger.test.ContractValidator;
import io.github.robwin.swagger.test.SwaggerAssertionConfig;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractContractValidator
implements ContractValidator {
    protected Map<String, Path> findExpectedPaths(Swagger expected, SwaggerAssertionConfig assertionConfig) {
        String pathsPrependExpected = assertionConfig.getPathsPrependExpected();
        String basePath = expected.getBasePath();
        if (StringUtils.isBlank((CharSequence)pathsPrependExpected) && this.isBlankOrSlash(basePath)) {
            return expected.getPaths();
        }
        String pathPrefix = null;
        if (StringUtils.isNotBlank((CharSequence)pathsPrependExpected)) {
            pathPrefix = pathsPrependExpected;
        } else if (!this.isBlankOrSlash(basePath)) {
            pathPrefix = basePath;
        }
        String finalPathPrefix = pathPrefix;
        return finalPathPrefix == null ? expected.getPaths() : this.getPathsWithPrefix(expected, finalPathPrefix);
    }

    protected Map<String, Path> getPathsIncludingBasePath(Swagger actual) {
        String basePath = actual.getBasePath();
        return this.isBlankOrSlash(basePath) ? actual.getPaths() : this.getPathsWithPrefix(actual, basePath);
    }

    private Map<String, Path> getPathsWithPrefix(Swagger swagger, String prefix) {
        return swagger.getPaths().entrySet().stream().collect(Collectors.toMap(e -> prefix + (String)e.getKey(), e -> (Path)e.getValue()));
    }

    private boolean isBlankOrSlash(String basePath) {
        return StringUtils.isBlank((CharSequence)basePath) || basePath.equals("/");
    }
}

