import ch.qos.logback.classic.encoder.PatternLayoutEncoder
import ch.qos.logback.classic.filter.LevelFilter
import ch.qos.logback.core.ConsoleAppender
import ch.qos.logback.core.rolling.RollingFileAppender
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy
import ch.qos.logback.core.status.NopStatusListener

import static ch.qos.logback.classic.Level.*
import static ch.qos.logback.core.spi.FilterReply.ACCEPT
import static ch.qos.logback.core.spi.FilterReply.DENY

statusListener(NopStatusListener)

appender("STDOUT", ConsoleAppender) {
    filter(LevelFilter) {
        level = ALL
        onMatch = ACCEPT
        onMismatch = DENY
    }
    encoder(PatternLayoutEncoder) {
        pattern = "%date{dd MMM yyyy;HH:mm:ss.SSS} %highlight(%-5level) %logger - %msg %n"
    }
}
appender("FILE-ERROR", RollingFileAppender) {
    filter(LevelFilter) {
        level = ERROR
        onMatch = ACCEPT
        onMismatch = DENY
    }
    file = "logs/yams-error.log"
    rollingPolicy(TimeBasedRollingPolicy) {
        fileNamePattern = "logs/plotpad-error.%d{yyyy-MM-dd}.log.gz"
        maxHistory = 30
    }
    encoder(PatternLayoutEncoder) {
        pattern = "%date{dd MMM yyyy;HH:mm:ss.SSS} %-5level %logger - %msg %n"
    }
}

appender("FILE-INFO", RollingFileAppender) {
    filter(LevelFilter) {
        level = INFO
        onMatch = ACCEPT
        onMismatch = DENY
    }
    file = "logs/yams-info.log"
    rollingPolicy(TimeBasedRollingPolicy) {
        fileNamePattern = "logs/plotpad-info.%d{yyyy-MM-dd}.log.gz"
        maxHistory = 30
    }
    encoder(PatternLayoutEncoder) {
        pattern = "%date{dd MMM yyyy;HH:mm:ss.SSS} %-5level %logger - %msg %n"
    }
}

logger("com.sun.jersey", WARN)
logger("org.eclipse.jetty", ERROR)


root(ALL, ["STDOUT", "FILE-INFO", "FILE-ERROR"])
