package io.github.rmuhamedgaliev.yams.server.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Singleton;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Path("/paths")
@Singleton
public class PathResource {
    @Context
    Dispatcher dispatcher;

    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public Response getAllResources(){
        Map<String, String> resources = Maps.newHashMap();

        ResourceMethodRegistry registry = (ResourceMethodRegistry) dispatcher.getRegistry();

        for (Map.Entry<String, List<ResourceInvoker>> entry : registry.getBounded().entrySet()) {
            for (ResourceInvoker invoker : entry.getValue()) {

                if (invoker instanceof ResourceMethodInvoker) {
                    Set<String> method = ((ResourceMethodInvoker) invoker).getHttpMethods();
                    resources.put(
                            entry.getKey(),
                            method.iterator().next()
                    );
                }

            }
        }

        Gson gson = new GsonBuilder()
                .setPrettyPrinting()
                .create();
        return Response.ok(gson.toJson(resources)).build();
    }
}
