package io.github.rmuhamedgaliev.yams.server;

import io.github.rmuhamedgaliev.yams.server.resources.PingResource;
import io.github.rmuhamedgaliev.yams.config.ConfigModule;
import org.jboss.resteasy.plugins.guice.ext.RequestScopeModule;

/**
 * Parent module for extends other Guice modules.
 * This module extended with {@link org.jboss.resteasy.plugins.guice.ext.RequestScopeModule} for work with RestEasy and Guice
 */
public class ServerModule extends RequestScopeModule {

    @Override
    protected void configure() {
        super.configure();

        install(new ConfigModule());
        bind(PingResource.class);
    }
}
