package io.github.rmuhamedgaliev.yams.config.impl;

import com.google.common.base.Preconditions;
import io.github.rmuhamedgaliev.yams.config.IReadConfigFile;
import io.github.rmuhamedgaliev.yams.config.mapping.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ReadConfigFile implements IReadConfigFile {
    private final Logger LOGGER = LoggerFactory.getLogger(ReadConfigFile.class);

    private boolean checkConfigExists() {
        return new File("config/yams.yaml").exists();
    }

    @Override
    public Configuration getConfig() throws IOException {
        String configPath = System.getenv("YAMS_CONFIG");
        if (configPath != null && configPath.trim().length() > 0) {
            configPath = configPath + "/config/yams.yaml";
        } else {
            configPath = "config/yams.yaml";
        }
        Preconditions.checkArgument(new File(configPath).exists(), "Config file not exists");
        Yaml yaml = new Yaml();
        Configuration configuration = null;
        try(InputStream inputStream = new FileInputStream(new File(configPath));) {
            configuration = yaml.loadAs(inputStream, Configuration.class);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return configuration;
    }
}
