/*
 * Decompiled with CFR 0.152.
 */
package net.linguica.gradle.maven.settings;

import java.io.File;
import net.linguica.gradle.maven.settings.MavenSettingsPluginExtension;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class LocalMavenSettingsLoader {
    public static final File GLOBAL_SETTINGS_FILE = new File(System.getenv("M2_HOME"), "conf/settings.xml");
    public static final String SETTINGS_SECURITY_FILE_LOCATION = System.getProperty("user.home") + "/.m2/settings-security.xml";
    private final MavenSettingsPluginExtension extension;

    public LocalMavenSettingsLoader(MavenSettingsPluginExtension extension) {
        this.extension = extension;
    }

    public Settings loadSettings() throws SettingsBuildingException {
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setUserSettingsFile(this.extension.getUserSettingsFile());
        settingsBuildingRequest.setGlobalSettingsFile(GLOBAL_SETTINGS_FILE);
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = factory.newInstance();
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        Settings settings = settingsBuildingResult.getEffectiveSettings();
        this.decryptCredentials(settings);
        return settings;
    }

    private void decryptCredentials(Settings settings) {
        try {
            String masterPassword = null;
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            File settingsSecurityFile = new File(SETTINGS_SECURITY_FILE_LOCATION);
            boolean hasSettingsSecurity = false;
            if (settingsSecurityFile.exists() && !settingsSecurityFile.isDirectory()) {
                SettingsSecurity settingsSecurity = SecUtil.read((String)SETTINGS_SECURITY_FILE_LOCATION, (boolean)true);
                masterPassword = cipher.decryptDecorated(settingsSecurity.getMaster(), "settings.security");
                hasSettingsSecurity = true;
            }
            for (Server server : settings.getServers()) {
                if (cipher.isEncryptedString(server.getPassword())) {
                    if (hasSettingsSecurity) {
                        server.setPassword(cipher.decryptDecorated(server.getPassword(), masterPassword));
                    } else {
                        throw new RuntimeException("Maven settings contains encrypted credentials yet no settings-security.xml exists.");
                    }
                }
                if (!cipher.isEncryptedString(server.getPassphrase())) continue;
                if (hasSettingsSecurity) {
                    server.setPassphrase(cipher.decryptDecorated(server.getPassphrase(), masterPassword));
                    continue;
                }
                throw new RuntimeException("Maven settings contains encrypted credentials yet no settings-security.xml exists.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt local Maven settings credentials.", e);
        }
    }
}

