/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview.utils;

import com.harissk.pdfium.util.Size;
import com.harissk.pdfium.util.SizeF;
import com.harissk.pdfpreview.utils.FitPolicy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/harissk/pdfpreview/utils/PageSizeCalculator;", "", "fitPolicy", "Lcom/harissk/pdfpreview/utils/FitPolicy;", "originalMaxWidthPageSize", "Lcom/harissk/pdfium/util/Size;", "originalMaxHeightPageSize", "viewSize", "fitEachPage", "", "(Lcom/harissk/pdfpreview/utils/FitPolicy;Lcom/harissk/pdfium/util/Size;Lcom/harissk/pdfium/util/Size;Lcom/harissk/pdfium/util/Size;Z)V", "heightRatio", "", "<set-?>", "Lcom/harissk/pdfium/util/SizeF;", "optimalMaxHeightPageSize", "getOptimalMaxHeightPageSize", "()Lcom/harissk/pdfium/util/SizeF;", "optimalMaxWidthPageSize", "getOptimalMaxWidthPageSize", "widthRatio", "calculate", "pageSize", "calculateMaxPages", "", "fitBoth", "maxWidth", "maxHeight", "fitHeight", "fitWidth", "pdfpreview_release"})
public final class PageSizeCalculator {
    @NotNull
    private final FitPolicy fitPolicy;
    @NotNull
    private final Size originalMaxWidthPageSize;
    @NotNull
    private final Size originalMaxHeightPageSize;
    @NotNull
    private final Size viewSize;
    private final boolean fitEachPage;
    @Nullable
    private SizeF optimalMaxWidthPageSize;
    @Nullable
    private SizeF optimalMaxHeightPageSize;
    private float widthRatio;
    private float heightRatio;

    public PageSizeCalculator(@NotNull FitPolicy fitPolicy, @NotNull Size originalMaxWidthPageSize, @NotNull Size originalMaxHeightPageSize, @NotNull Size viewSize, boolean fitEachPage) {
        Intrinsics.checkNotNullParameter((Object)((Object)fitPolicy), (String)"fitPolicy");
        Intrinsics.checkNotNullParameter((Object)originalMaxWidthPageSize, (String)"originalMaxWidthPageSize");
        Intrinsics.checkNotNullParameter((Object)originalMaxHeightPageSize, (String)"originalMaxHeightPageSize");
        Intrinsics.checkNotNullParameter((Object)viewSize, (String)"viewSize");
        this.fitPolicy = fitPolicy;
        this.originalMaxWidthPageSize = originalMaxWidthPageSize;
        this.originalMaxHeightPageSize = originalMaxHeightPageSize;
        this.viewSize = viewSize;
        this.fitEachPage = fitEachPage;
        this.calculateMaxPages();
    }

    @Nullable
    public final SizeF getOptimalMaxWidthPageSize() {
        return this.optimalMaxWidthPageSize;
    }

    @Nullable
    public final SizeF getOptimalMaxHeightPageSize() {
        return this.optimalMaxHeightPageSize;
    }

    @NotNull
    public final SizeF calculate(@NotNull Size pageSize) {
        Intrinsics.checkNotNullParameter((Object)pageSize, (String)"pageSize");
        if (pageSize.getWidth() <= 0 || pageSize.getHeight() <= 0) {
            return new SizeF(0.0f, 0.0f);
        }
        float maxWidth = this.fitEachPage ? (float)this.viewSize.getWidth() : (float)pageSize.getWidth() * this.widthRatio;
        float maxHeight = this.fitEachPage ? (float)this.viewSize.getHeight() : (float)pageSize.getHeight() * this.heightRatio;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.fitPolicy.ordinal()]) {
            case 1 -> this.fitHeight(pageSize, maxHeight);
            case 2 -> this.fitBoth(pageSize, maxWidth, maxHeight);
            default -> this.fitWidth(pageSize, maxWidth);
        };
    }

    private final void calculateMaxPages() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.fitPolicy.ordinal()]) {
            case 1: {
                SizeF sizeF = this.optimalMaxHeightPageSize = this.fitHeight(this.originalMaxHeightPageSize, this.viewSize.getHeight());
                this.heightRatio = (sizeF != null ? sizeF.getHeight() : 0.0f) / (float)this.originalMaxHeightPageSize.getHeight();
                this.optimalMaxWidthPageSize = this.fitHeight(this.originalMaxWidthPageSize, (float)this.originalMaxWidthPageSize.getHeight() * this.heightRatio);
                break;
            }
            case 2: {
                SizeF localOptimalMaxWidth = this.fitBoth(this.originalMaxWidthPageSize, this.viewSize.getWidth(), this.viewSize.getHeight());
                float localWidthRatio = localOptimalMaxWidth.getWidth() / (float)this.originalMaxWidthPageSize.getWidth();
                SizeF sizeF = this.optimalMaxHeightPageSize = this.fitBoth(this.originalMaxHeightPageSize, (float)this.originalMaxHeightPageSize.getWidth() * localWidthRatio, this.viewSize.getHeight());
                this.heightRatio = (sizeF != null ? sizeF.getHeight() : 0.0f) / (float)this.originalMaxHeightPageSize.getHeight();
                SizeF sizeF2 = this.optimalMaxWidthPageSize = this.fitBoth(this.originalMaxWidthPageSize, this.viewSize.getWidth(), (float)this.originalMaxWidthPageSize.getHeight() * this.heightRatio);
                this.widthRatio = (sizeF2 != null ? sizeF2.getWidth() : 0.0f) / (float)this.originalMaxWidthPageSize.getWidth();
                break;
            }
            default: {
                SizeF sizeF = this.optimalMaxWidthPageSize = this.fitWidth(this.originalMaxWidthPageSize, this.viewSize.getWidth());
                this.widthRatio = (sizeF != null ? sizeF.getWidth() : 0.0f) / (float)this.originalMaxWidthPageSize.getWidth();
                this.optimalMaxHeightPageSize = this.fitWidth(this.originalMaxHeightPageSize, (float)this.originalMaxHeightPageSize.getWidth() * this.widthRatio);
            }
        }
    }

    private final SizeF fitWidth(Size pageSize, float maxWidth) {
        if (pageSize.getWidth() <= 0 || pageSize.getHeight() <= 0 || maxWidth <= 0.0f) {
            return new SizeF(0.0f, 0.0f);
        }
        float ratio = (float)pageSize.getWidth() / (float)pageSize.getHeight();
        if (Float.isNaN(ratio) || Float.isInfinite(ratio) || ratio <= 0.0f) {
            return new SizeF(0.0f, 0.0f);
        }
        float height = (float)Math.floor(maxWidth / ratio);
        float f = height;
        return new SizeF(maxWidth, !Float.isInfinite(f) && !Float.isNaN(f) && height > 0.0f ? height : 0.0f);
    }

    private final SizeF fitHeight(Size pageSize, float maxHeight) {
        if (pageSize.getWidth() <= 0 || pageSize.getHeight() <= 0 || maxHeight <= 0.0f) {
            return new SizeF(0.0f, 0.0f);
        }
        float ratio = (float)pageSize.getHeight() / (float)pageSize.getWidth();
        if (Float.isNaN(ratio) || Float.isInfinite(ratio) || ratio <= 0.0f) {
            return new SizeF(0.0f, 0.0f);
        }
        float width = (float)Math.floor(maxHeight / ratio);
        float f = width;
        return new SizeF(!Float.isInfinite(f) && !Float.isNaN(f) && width > 0.0f ? width : 0.0f, maxHeight);
    }

    private final SizeF fitBoth(Size pageSize, float maxWidth, float maxHeight) {
        if (pageSize.getWidth() <= 0 || pageSize.getHeight() <= 0 || maxWidth <= 0.0f || maxHeight <= 0.0f) {
            return new SizeF(0.0f, 0.0f);
        }
        float ratio = (float)pageSize.getWidth() / (float)pageSize.getHeight();
        if (Float.isNaN(ratio) || Float.isInfinite(ratio) || ratio <= 0.0f) {
            return new SizeF(0.0f, 0.0f);
        }
        float w = maxWidth;
        float h = (float)Math.floor(maxWidth / ratio);
        float f = h;
        if (!(!Float.isInfinite(f) && !Float.isNaN(f)) || h <= 0.0f || h > maxHeight) {
            h = maxHeight;
            w = (float)Math.floor(maxHeight * ratio);
            f = w;
            if (!(!Float.isInfinite(f) && !Float.isNaN(f)) || w <= 0.0f) {
                return new SizeF(0.0f, 0.0f);
            }
        }
        return new SizeF(w, h);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FitPolicy.values().length];
            try {
                nArray[FitPolicy.HEIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FitPolicy.BOTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

