/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview.source;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import com.harissk.pdfium.PdfiumCore;
import com.harissk.pdfpreview.source.DocumentSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/harissk/pdfpreview/source/AssetSource;", "Lcom/harissk/pdfpreview/source/DocumentSource;", "assetName", "", "(Ljava/lang/String;)V", "createDocument", "", "context", "Landroid/content/Context;", "core", "Lcom/harissk/pdfium/PdfiumCore;", "password", "pdfpreview_release"})
public final class AssetSource
implements DocumentSource {
    @NotNull
    private final String assetName;

    public AssetSource(@NotNull String assetName) {
        Intrinsics.checkNotNullParameter((Object)assetName, (String)"assetName");
        this.assetName = assetName;
    }

    @Override
    public long createDocument(@NotNull Context context, @NotNull PdfiumCore core, @Nullable String password) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)core, (String)"core");
        File outFile = new File(context.getCacheDir(), this.assetName + "-pdfview.pdf");
        if (StringsKt.contains$default((CharSequence)this.assetName, (CharSequence)"/", (boolean)false, (int)2, null)) {
            File file = outFile.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
        }
        InputStream inputStream = context.getAssets().open(this.assetName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        InputStream inputStream2 = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        closeable = new FileOutputStream(outFile);
        n = 8192;
        ByteStreamsKt.copyTo$default((InputStream)inputStream2, (OutputStream)(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n)), (int)0, (int)2, null);
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)outFile, (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"open(...)");
        return core.newDocument(parcelFileDescriptor, password);
    }
}

