/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview.scroll;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.view.ViewGroupKt;
import com.harissk.pdfpreview.PDFView;
import com.harissk.pdfpreview.scroll.DefaultScrollHandle$setupLayout$;
import com.harissk.pdfpreview.scroll.ScrollHandle;
import com.harissk.pdfpreview.utils.UtilKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#H\u0017J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\tH\u0016J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020&J\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\tJ\u0012\u0010/\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u00100\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/harissk/pdfpreview/scroll/DefaultScrollHandle;", "Landroid/widget/RelativeLayout;", "Lcom/harissk/pdfpreview/scroll/ScrollHandle;", "context", "Landroid/content/Context;", "inverted", "", "(Landroid/content/Context;Z)V", "currentPos", "", "estimatedMinThicknessPx", "getEstimatedMinThicknessPx", "()F", "estimatedMinThicknessPx$delegate", "Lkotlin/Lazy;", "handler", "Landroid/os/Handler;", "hidePageScrollerRunnable", "Ljava/lang/Runnable;", "pdfView", "Lcom/harissk/pdfpreview/PDFView;", "relativeHandlerMiddle", "shown", "getShown", "()Z", "textView", "Landroid/widget/TextView;", "calculateMiddle", "", "destroyLayout", "hide", "hideDelayed", "isPDFViewReady", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setPageNum", "pageNum", "", "setPosition", "pos", "setScroll", "position", "setTextColor", "color", "setTextSize", "size", "setupLayout", "show", "Companion", "pdfpreview_release"})
@SuppressLint(value={"ViewConstructor"})
@SourceDebugExtension(value={"SMAP\nDefaultScrollHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultScrollHandle.kt\ncom/harissk/pdfpreview/scroll/DefaultScrollHandle\n+ 2 Color.kt\nandroidx/core/graphics/ColorKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,308:1\n470#2:309\n470#2:310\n470#2:311\n470#2:312\n473#3:313\n1313#3,2:314\n1#4:316\n260#5:317\n*S KotlinDebug\n*F\n+ 1 DefaultScrollHandle.kt\ncom/harissk/pdfpreview/scroll/DefaultScrollHandle\n*L\n76#1:309\n77#1:310\n81#1:311\n82#1:312\n128#1:313\n129#1:314,2\n204#1:317\n*E\n"})
public final class DefaultScrollHandle
extends RelativeLayout
implements ScrollHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final boolean inverted;
    private float relativeHandlerMiddle;
    @NotNull
    private final TextView textView;
    @Nullable
    private PDFView pdfView;
    private float currentPos;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Runnable hidePageScrollerRunnable;
    @NotNull
    private final Lazy estimatedMinThicknessPx$delegate;
    private static final float DEFAULT_TEXT_PADDING_HORIZONTAL = 12.0f;
    private static final float DEFAULT_TEXT_PADDING_VERTICAL = 6.0f;
    private static final float DEFAULT_TEXT_SIZE = 12.0f;
    private static final float DEFAULT_ELEVATION_DP = 2.0f;

    public DefaultScrollHandle(@NotNull Context context, boolean inverted) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        this.inverted = inverted;
        this.textView = new TextView(this.context);
        this.handler = new Handler(Looper.getMainLooper());
        this.hidePageScrollerRunnable = () -> DefaultScrollHandle.hidePageScrollerRunnable$lambda$0(this);
        this.estimatedMinThicknessPx$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ DefaultScrollHandle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                return Float.valueOf(UtilKt.toPx(DefaultScrollHandle.access$getContext$p(this.this$0), 12.0f) + UtilKt.toPx(DefaultScrollHandle.access$getContext$p(this.this$0), 6.0f) * 2);
            }
        }));
        this.setVisibility(4);
        this.setTextSize(12.0f);
    }

    public /* synthetic */ DefaultScrollHandle(Context context, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(context, bl);
    }

    private final float getEstimatedMinThicknessPx() {
        Lazy lazy = this.estimatedMinThicknessPx$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setupLayout(@Nullable PDFView pdfView) {
        void $this$forEach$iv;
        GradientDrawable gradientDrawable;
        if (pdfView == null || pdfView.isRecycled$pdfpreview_release()) {
            return;
        }
        int nightModeFlags = this.context.getResources().getConfiguration().uiMode & 0x30;
        boolean isNightMode = nightModeFlags == 32;
        int handleColor = 0;
        int textColor = 0;
        if (isNightMode) {
            $this$toColorInt$iv = "#333333";
            $i$f$toColorInt = false;
            handleColor = Color.parseColor((String)$this$toColorInt$iv);
            $this$toColorInt$iv = "#E0E0E0";
            $i$f$toColorInt = false;
            textColor = Color.parseColor((String)$this$toColorInt$iv);
        } else {
            $this$toColorInt$iv = "#E0E0E0";
            $i$f$toColorInt = false;
            handleColor = Color.parseColor((String)$this$toColorInt$iv);
            $this$toColorInt$iv = "#212121";
            $i$f$toColorInt = false;
            textColor = Color.parseColor((String)$this$toColorInt$iv);
        }
        this.setTextColor(textColor);
        this.textView.setMaxLines(1);
        int horizontalPadding = UtilKt.toPx(this.context, 12.0f);
        int verticalPadding = UtilKt.toPx(this.context, 6.0f);
        this.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        int align = pdfView.isSwipeVertical$pdfpreview_release() ? (this.inverted ? 9 : 11) : (this.inverted ? 10 : 12);
        RelativeLayout.LayoutParams layoutParamsForPdfView = new RelativeLayout.LayoutParams(-2, -2);
        layoutParamsForPdfView.addRule(align);
        GradientDrawable $this$setupLayout_u24lambda_u241 = gradientDrawable = new GradientDrawable();
        boolean bl2 = false;
        $this$setupLayout_u24lambda_u241.setColor(handleColor);
        $this$setupLayout_u24lambda_u241.setCornerRadius((float)UtilKt.toPx(this.context, 100.0f));
        GradientDrawable handleDrawable = gradientDrawable;
        this.setBackground((Drawable)handleDrawable);
        this.setElevation(UtilKt.toPx(this.context, 2.0f));
        RelativeLayout.LayoutParams tvlp = new RelativeLayout.LayoutParams(-2, -2);
        tvlp.addRule(13, -1);
        if (this.textView.getParent() != null) {
            ViewParent bl2 = this.textView.getParent();
            ViewGroup viewGroup = bl2 instanceof ViewGroup ? (ViewGroup)bl2 : null;
            if (viewGroup != null) {
                viewGroup.removeView((View)this.textView);
            }
        }
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvlp);
        Sequence $this$filterIsInstance$iv = ViewGroupKt.getChildren((ViewGroup)((ViewGroup)pdfView));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)setupLayout$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        $this$filterIsInstance$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DefaultScrollHandle scrollHandle = (DefaultScrollHandle)element$iv;
            boolean bl3 = false;
            pdfView.removeView((View)scrollHandle);
        }
        pdfView.addView((View)this, (ViewGroup.LayoutParams)layoutParamsForPdfView);
        this.pdfView = pdfView;
    }

    @Override
    public void destroyLayout() {
        block0: {
            PDFView pDFView = this.pdfView;
            if (pDFView == null) break block0;
            pDFView.removeView((View)this);
        }
    }

    @Override
    public void setScroll(float position) {
        float f;
        block7: {
            block6: {
                PDFView pDFView;
                PDFView pDFView2 = this.pdfView;
                if (pDFView2 == null) break block6;
                PDFView it = pDFView = pDFView2;
                boolean bl = false;
                pDFView2 = !it.isRecycled$pdfpreview_release() ? pDFView : null;
                if (pDFView2 != null) break block7;
            }
            return;
        }
        if (!this.getShown()) {
            this.show();
        }
        this.handler.removeCallbacks(this.hidePageScrollerRunnable);
        PDFView pDFView = this.pdfView;
        if (Intrinsics.areEqual((Object)(pDFView != null ? Boolean.valueOf(pDFView.isSwipeVertical$pdfpreview_release()) : null), (Object)true)) {
            PDFView pDFView3 = this.pdfView;
            f = (float)(pDFView3 != null ? pDFView3.getHeight() : 0) * position;
        } else {
            PDFView pDFView4 = this.pdfView;
            f = (float)(pDFView4 != null ? pDFView4.getWidth() : 0) * position;
        }
        float targetPos = f;
        this.setPosition(targetPos);
    }

    /*
     * WARNING - void declaration
     */
    private final void setPosition(float pos) {
        void it;
        if (Float.isNaN(pos) || Float.isInfinite(pos)) {
            return;
        }
        PDFView pDFView = this.pdfView;
        if (pDFView == null) {
            return;
        }
        PDFView currentPdfView = pDFView;
        float pdfViewSize = currentPdfView.isSwipeVertical$pdfpreview_release() ? (float)currentPdfView.getHeight() : (float)currentPdfView.getWidth();
        Float f = Float.valueOf(this.getHeight());
        float it22 = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = it22 > 0.0f ? f : null;
        float currentHandleHeight = f2 != null ? f2.floatValue() : this.getEstimatedMinThicknessPx();
        Float it22 = Float.valueOf(this.getWidth());
        float it3 = ((Number)it22).floatValue();
        boolean bl2 = false;
        Float f3 = it3 > 0.0f ? it22 : null;
        float currentHandleWidth = f3 != null ? f3.floatValue() : this.getEstimatedMinThicknessPx();
        float handleDimension = currentPdfView.isSwipeVertical$pdfpreview_release() ? currentHandleHeight : currentHandleWidth;
        float v = pos - this.relativeHandlerMiddle;
        Float f4 = Float.valueOf(handleDimension);
        float f5 = ((Number)f4).floatValue();
        float f6 = pdfViewSize;
        float f7 = 0.0f;
        float f8 = v;
        boolean bl3 = false;
        boolean bl4 = it > 0.0f;
        Float f9 = bl4 ? f4 : null;
        v = RangesKt.coerceIn((float)f8, (float)f7, (float)(f6 - (f9 != null ? f9.floatValue() : 0.0f)));
        if (currentPdfView.isSwipeVertical$pdfpreview_release()) {
            this.setY(v);
        } else {
            this.setX(v);
        }
        this.calculateMiddle();
        this.invalidate();
    }

    private final void calculateMiddle() {
        block1: {
            PDFView pDFView = this.pdfView;
            if (pDFView == null) break block1;
            PDFView view = pDFView;
            boolean bl = false;
            Float f = Float.valueOf(this.getHeight());
            float it22 = ((Number)f).floatValue();
            boolean bl2 = false;
            Float f2 = it22 > 0.0f ? f : null;
            float h = f2 != null ? f2.floatValue() : this.getEstimatedMinThicknessPx();
            Float it22 = Float.valueOf(this.getWidth());
            float it = ((Number)it22).floatValue();
            boolean bl3 = false;
            Float f3 = it > 0.0f ? it22 : null;
            float w = f3 != null ? f3.floatValue() : this.getEstimatedMinThicknessPx();
            f = view.isSwipeVertical$pdfpreview_release() ? new Triple((Object)Float.valueOf(this.getY()), (Object)Float.valueOf(h), (Object)Float.valueOf(view.getHeight())) : new Triple((Object)Float.valueOf(this.getX()), (Object)Float.valueOf(w), (Object)Float.valueOf(view.getWidth()));
            float pos = ((Number)f.component1()).floatValue();
            float viewSize = ((Number)f.component2()).floatValue();
            float pdfViewSize = ((Number)f.component3()).floatValue();
            if (pdfViewSize > 0.0f && viewSize > 0.0f) {
                this.relativeHandlerMiddle = (pos + this.relativeHandlerMiddle) / pdfViewSize * viewSize;
            }
        }
    }

    @Override
    public void hideDelayed() {
        this.handler.postDelayed(this.hidePageScrollerRunnable, 1000L);
    }

    @Override
    public void setPageNum(int pageNum) {
        PDFView pDFView = this.pdfView;
        int totalPages = pDFView != null ? pDFView.getPageCount() : 0;
        String text = pageNum + "/" + totalPages;
        if (!Intrinsics.areEqual((Object)this.textView.getText(), (Object)text)) {
            this.textView.setText((CharSequence)text);
        }
    }

    @Override
    public boolean getShown() {
        View $this$isVisible$iv = (View)this;
        boolean $i$f$isVisible = false;
        return $this$isVisible$iv.getVisibility() == 0;
    }

    @Override
    public void show() {
        this.setVisibility(0);
    }

    @Override
    public void hide() {
        this.setVisibility(4);
    }

    public final void setTextColor(int color) {
        this.textView.setTextColor(color);
    }

    public final void setTextSize(float size) {
        this.textView.setTextSize(1, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPDFViewReady() {
        if (this.pdfView == null) return false;
        PDFView pDFView = this.pdfView;
        Intrinsics.checkNotNull((Object)((Object)pDFView));
        if (pDFView.getPageCount() <= 0) return false;
        PDFView pDFView2 = this.pdfView;
        Intrinsics.checkNotNull((Object)((Object)pDFView2));
        if (pDFView2.isRecycled$pdfpreview_release()) return false;
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isPDFViewReady()) {
            return super.onTouchEvent(event);
        }
        PDFView pDFView = this.pdfView;
        Intrinsics.checkNotNull((Object)((Object)pDFView));
        PDFView currentPdfView = pDFView;
        Float f = Float.valueOf(this.getHeight());
        float it22 = ((Number)f).floatValue();
        boolean bl = false;
        Float f2 = it22 > 0.0f ? f : null;
        float currentHandleHeight = f2 != null ? f2.floatValue() : this.getEstimatedMinThicknessPx();
        Float it22 = Float.valueOf(this.getWidth());
        float it = ((Number)it22).floatValue();
        boolean bl2 = false;
        Float f3 = it > 0.0f ? it22 : null;
        float currentHandleWidth = f3 != null ? f3.floatValue() : this.getEstimatedMinThicknessPx();
        switch (event.getAction()) {
            case 0: 
            case 5: {
                currentPdfView.stopFling();
                currentPdfView.setScrollHandleDragging$pdfpreview_release(true);
                this.handler.removeCallbacks(this.hidePageScrollerRunnable);
                this.currentPos = currentPdfView.isSwipeVertical$pdfpreview_release() ? event.getRawY() - this.getY() : event.getRawX() - this.getX();
                float eventPos = currentPdfView.isSwipeVertical$pdfpreview_release() ? event.getRawY() : event.getRawX();
                this.setPosition(eventPos - this.currentPos + this.relativeHandlerMiddle);
                currentPdfView.performHapticFeedback(1);
                return true;
            }
            case 2: {
                float actualHandleSize;
                float eventPos = currentPdfView.isSwipeVertical$pdfpreview_release() ? event.getRawY() : event.getRawX();
                this.setPosition(eventPos - this.currentPos + this.relativeHandlerMiddle);
                float handleCenter = currentPdfView.isSwipeVertical$pdfpreview_release() ? this.getY() + currentHandleHeight / 2.0f : this.getX() + currentHandleWidth / 2.0f;
                float viewSize = currentPdfView.isSwipeVertical$pdfpreview_release() ? (float)currentPdfView.getHeight() : (float)currentPdfView.getWidth();
                float f4 = actualHandleSize = currentPdfView.isSwipeVertical$pdfpreview_release() ? currentHandleHeight : currentHandleWidth;
                if (viewSize > actualHandleSize && actualHandleSize > 0.0f) {
                    float offset = (handleCenter - actualHandleSize / 2.0f) / (viewSize - actualHandleSize);
                    if (!currentPdfView.getSinglePageMode()) {
                        currentPdfView.setPositionOffset(RangesKt.coerceIn((float)offset, (float)0.0f, (float)1.0f), false);
                        int actualCurrentPage = currentPdfView.getPageAtPositionOffset(RangesKt.coerceIn((float)offset, (float)0.0f, (float)1.0f));
                        this.setPageNum(actualCurrentPage + 1);
                    } else {
                        this.setPageNum(currentPdfView.getCurrentPage() + 1);
                    }
                }
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                currentPdfView.setScrollHandleDragging$pdfpreview_release(false);
                currentPdfView.updateScrollUIElements$pdfpreview_release();
                currentPdfView.loadPageByOffset$pdfpreview_release();
                this.hideDelayed();
                currentPdfView.performPageSnap$pdfpreview_release();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private static final void hidePageScrollerRunnable$lambda$0(DefaultScrollHandle this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hide();
    }

    public static final /* synthetic */ Context access$getContext$p(DefaultScrollHandle $this) {
        return $this.context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/harissk/pdfpreview/scroll/DefaultScrollHandle$Companion;", "", "()V", "DEFAULT_ELEVATION_DP", "", "DEFAULT_TEXT_PADDING_HORIZONTAL", "DEFAULT_TEXT_PADDING_VERTICAL", "DEFAULT_TEXT_SIZE", "pdfpreview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

