/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.SparseBooleanArray;
import com.harissk.pdfium.Bookmark;
import com.harissk.pdfium.Link;
import com.harissk.pdfium.Meta;
import com.harissk.pdfium.PdfiumCore;
import com.harissk.pdfium.exception.PageRenderingException;
import com.harissk.pdfium.util.Size;
import com.harissk.pdfium.util.SizeF;
import com.harissk.pdfpreview.utils.FitPolicy;
import com.harissk.pdfpreview.utils.PageSizeCalculator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ]2\u00020\u0001:\u0001]B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\b\b\u0002\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0012J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\nH\u0002J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ\u0006\u00106\u001a\u000202J\u000e\u00107\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002090\tH\u0086@\u00a2\u0006\u0002\u0010:J\u000e\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015J\u000e\u0010=\u001a\u00020>H\u0086@\u00a2\u0006\u0002\u0010:J\u0016\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015J\u0016\u0010A\u001a\u00020\u00152\u0006\u00103\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0015J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\t2\u0006\u00103\u001a\u00020\nJ\u0016\u0010D\u001a\u00020\u00152\u0006\u00103\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0015J\u0010\u0010E\u001a\u0004\u0018\u00010\u00172\u0006\u00103\u001a\u00020\nJ\u0016\u0010F\u001a\u00020\u00152\u0006\u00103\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0015J\u0016\u0010G\u001a\u00020\u00172\u0006\u00103\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0015J\u0016\u0010H\u001a\u00020\u00152\u0006\u00103\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0015J6\u0010I\u001a\u00020J2\u0006\u00103\u001a\u00020\n2\u0006\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020JJ\u000e\u0010P\u001a\u00020\f2\u0006\u00103\u001a\u00020\nJ\u000e\u0010Q\u001a\u00020\f2\u0006\u00103\u001a\u00020\nJ\u0010\u0010R\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010S\u001a\u000202H\u0002J\b\u0010T\u001a\u000202H\u0002J\u000e\u0010U\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010V\u001a\u0002022\u0006\u0010W\u001a\u00020X2\u0006\u00103\u001a\u00020\n2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\fJ\u0010\u0010\\\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001aR\u0010\u0010 \u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\u00070(j\b\u0012\u0004\u0012\u00020\u0007`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\u00150(j\b\u0012\u0004\u0012\u00020\u0015`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010+\u001a\u0012\u0012\u0004\u0012\u00020\u00170(j\b\u0012\u0004\u0012\u00020\u0017`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u0012\u0012\u0004\u0012\u00020\u00150(j\b\u0012\u0004\u0012\u00020\u0015`)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u00020\n2\u0006\u0010-\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/harissk/pdfpreview/PdfFile;", "", "pdfiumCore", "Lcom/harissk/pdfium/PdfiumCore;", "pageFitPolicy", "Lcom/harissk/pdfpreview/utils/FitPolicy;", "viewSize", "Lcom/harissk/pdfium/util/Size;", "originalUserPages", "", "", "isVertical", "", "spacingPx", "autoSpacing", "fitEachPage", "maxPageCacheSize", "singlePageMode", "(Lcom/harissk/pdfium/PdfiumCore;Lcom/harissk/pdfpreview/utils/FitPolicy;Lcom/harissk/pdfium/util/Size;Ljava/util/List;ZIZZIZ)V", "currentViewSize", "documentLength", "", "maxHeightPageSize", "Lcom/harissk/pdfium/util/SizeF;", "maxPageHeight", "getMaxPageHeight", "()F", "maxPageSize", "getMaxPageSize", "()Lcom/harissk/pdfium/util/SizeF;", "maxPageWidth", "getMaxPageWidth", "maxWidthPageSize", "openedPageQueue", "Ljava/util/Queue;", "openedPages", "Landroid/util/SparseBooleanArray;", "originalMaxHeightPageSize", "originalMaxWidthPageSize", "originalPageSizes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pageOffsets", "pageSizes", "pageSpacing", "<set-?>", "pagesCount", "getPagesCount", "()I", "closePage", "", "pageIndex", "determineValidPageNumberFrom", "userPage", "dispose", "documentPage", "getBookmarks", "Lcom/harissk/pdfium/Bookmark;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDocLen", "zoom", "getMetaData", "Lcom/harissk/pdfium/Meta;", "getPageAtOffset", "offset", "getPageLength", "getPageLinks", "Lcom/harissk/pdfium/Link;", "getPageOffset", "getPageSize", "getPageSpacing", "getScaledPageSize", "getSecondaryPageOffset", "mapRectToDevice", "Landroid/graphics/RectF;", "startX", "startY", "sizeX", "sizeY", "rect", "openPage", "pageHasError", "prepareAutoSpacing", "prepareDocLen", "preparePagesOffset", "recalculatePageSizes", "renderPageBitmap", "bitmap", "Landroid/graphics/Bitmap;", "bounds", "Landroid/graphics/Rect;", "annotationRendering", "setup", "Companion", "pdfpreview_release"})
@SourceDebugExtension(value={"SMAP\nPdfFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfFile.kt\ncom/harissk/pdfpreview/PdfFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SparseBooleanArray.kt\nandroidx/core/util/SparseBooleanArrayKt\n*L\n1#1,422:1\n1#2:423\n49#3:424\n*S KotlinDebug\n*F\n+ 1 PdfFile.kt\ncom/harissk/pdfpreview/PdfFile\n*L\n334#1:424\n*E\n"})
public final class PdfFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PdfiumCore pdfiumCore;
    @NotNull
    private final FitPolicy pageFitPolicy;
    private final boolean isVertical;
    private final int spacingPx;
    private final boolean autoSpacing;
    private final boolean fitEachPage;
    private final int maxPageCacheSize;
    private final boolean singlePageMode;
    private int pagesCount;
    @NotNull
    private final ArrayList<Size> originalPageSizes;
    @NotNull
    private final ArrayList<SizeF> pageSizes;
    @NotNull
    private final SparseBooleanArray openedPages;
    @NotNull
    private final Queue<Integer> openedPageQueue;
    @NotNull
    private Size originalMaxWidthPageSize;
    @NotNull
    private Size originalMaxHeightPageSize;
    @Nullable
    private SizeF maxHeightPageSize;
    @Nullable
    private SizeF maxWidthPageSize;
    @NotNull
    private final ArrayList<Float> pageOffsets;
    @NotNull
    private final ArrayList<Float> pageSpacing;
    private float documentLength;
    @Nullable
    private Size currentViewSize;
    @Nullable
    private List<Integer> originalUserPages;
    @NotNull
    private static final Object lock = new Object();

    public PdfFile(@NotNull PdfiumCore pdfiumCore, @NotNull FitPolicy pageFitPolicy, @NotNull Size viewSize, @Nullable List<Integer> originalUserPages, boolean isVertical, int spacingPx, boolean autoSpacing, boolean fitEachPage, int maxPageCacheSize, boolean singlePageMode) {
        Intrinsics.checkNotNullParameter((Object)pdfiumCore, (String)"pdfiumCore");
        Intrinsics.checkNotNullParameter((Object)((Object)pageFitPolicy), (String)"pageFitPolicy");
        Intrinsics.checkNotNullParameter((Object)viewSize, (String)"viewSize");
        this.pdfiumCore = pdfiumCore;
        this.pageFitPolicy = pageFitPolicy;
        this.isVertical = isVertical;
        this.spacingPx = spacingPx;
        this.autoSpacing = autoSpacing;
        this.fitEachPage = fitEachPage;
        this.maxPageCacheSize = maxPageCacheSize;
        this.singlePageMode = singlePageMode;
        this.originalPageSizes = new ArrayList();
        this.pageSizes = new ArrayList();
        this.openedPages = new SparseBooleanArray();
        this.openedPageQueue = new LinkedList();
        this.originalMaxWidthPageSize = new Size(0, 0);
        this.originalMaxHeightPageSize = new Size(0, 0);
        this.maxHeightPageSize = new SizeF(0.0f, 0.0f);
        this.maxWidthPageSize = new SizeF(0.0f, 0.0f);
        this.pageOffsets = new ArrayList();
        this.pageSpacing = new ArrayList();
        this.originalUserPages = originalUserPages;
        this.setup(viewSize);
    }

    public /* synthetic */ PdfFile(PdfiumCore pdfiumCore, FitPolicy fitPolicy, Size size, List list, boolean bl, int n, boolean bl2, boolean bl3, int n2, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x200) != 0) {
            bl4 = false;
        }
        this(pdfiumCore, fitPolicy, size, list, bl, n, bl2, bl3, n2, bl4);
    }

    public final int getPagesCount() {
        return this.pagesCount;
    }

    private final void setup(Size viewSize) {
        int n;
        if (this.originalUserPages != null) {
            List<Integer> list = this.originalUserPages;
            Intrinsics.checkNotNull(list);
            n = list.size();
        } else {
            n = this.pdfiumCore.getPageCount();
        }
        this.pagesCount = n;
        int n2 = this.pagesCount;
        for (int i = 0; i < n2; ++i) {
            Size pageSize = this.pdfiumCore.getPageSize(this.documentPage(i));
            if (pageSize.getWidth() > this.originalMaxWidthPageSize.getWidth()) {
                this.originalMaxWidthPageSize = pageSize;
            }
            if (pageSize.getHeight() > this.originalMaxHeightPageSize.getHeight()) {
                this.originalMaxHeightPageSize = pageSize;
            }
            this.originalPageSizes.add(pageSize);
        }
        this.recalculatePageSizes(viewSize);
    }

    public final void recalculatePageSizes(@NotNull Size viewSize) {
        Intrinsics.checkNotNullParameter((Object)viewSize, (String)"viewSize");
        this.currentViewSize = viewSize;
        this.pageSizes.clear();
        PageSizeCalculator calculator = new PageSizeCalculator(this.pageFitPolicy, this.originalMaxWidthPageSize, this.originalMaxHeightPageSize, viewSize, this.fitEachPage);
        this.maxWidthPageSize = calculator.getOptimalMaxWidthPageSize();
        this.maxHeightPageSize = calculator.getOptimalMaxHeightPageSize();
        for (Size size : this.originalPageSizes) {
            Intrinsics.checkNotNull((Object)size);
            this.pageSizes.add(calculator.calculate(size));
        }
        if (this.autoSpacing) {
            this.prepareAutoSpacing(viewSize);
        }
        this.prepareDocLen();
        this.preparePagesOffset();
    }

    @Nullable
    public final SizeF getPageSize(int pageIndex) {
        return this.documentPage(pageIndex) < 0 ? null : (SizeF)CollectionsKt.getOrNull((List)this.pageSizes, (int)pageIndex);
    }

    @NotNull
    public final SizeF getScaledPageSize(int pageIndex, float zoom) {
        SizeF sizeF = this.getPageSize(pageIndex);
        if (sizeF == null) {
            sizeF = new SizeF(0.0f, 0.0f);
        }
        SizeF size = sizeF;
        return new SizeF(size.getWidth() * zoom, size.getHeight() * zoom);
    }

    @Nullable
    public final SizeF getMaxPageSize() {
        return this.isVertical ? this.maxWidthPageSize : this.maxHeightPageSize;
    }

    public final float getMaxPageWidth() {
        SizeF sizeF = this.getMaxPageSize();
        return sizeF != null ? sizeF.getWidth() : 0.0f;
    }

    public final float getMaxPageHeight() {
        SizeF sizeF = this.getMaxPageSize();
        return sizeF != null ? sizeF.getHeight() : 0.0f;
    }

    private final void prepareAutoSpacing(Size viewSize) {
        this.pageSpacing.clear();
        int n = this.pagesCount;
        for (int i = 0; i < n; ++i) {
            SizeF pageSize;
            Intrinsics.checkNotNullExpressionValue((Object)this.pageSizes.get(i), (String)"get(...)");
            float spacing = Math.max(0.0f, this.isVertical ? (float)viewSize.getHeight() - pageSize.getHeight() : (float)viewSize.getWidth() - pageSize.getWidth());
            if (i < this.pagesCount - 1) {
                spacing += (float)this.spacingPx;
            }
            this.pageSpacing.add(Float.valueOf(spacing));
        }
    }

    private final void prepareDocLen() {
        if (this.singlePageMode) {
            SizeF sizeF = (SizeF)CollectionsKt.getOrNull((List)this.pageSizes, (int)0);
            if (sizeF == null) {
                sizeF = new SizeF(0.0f, 0.0f);
            }
            SizeF pageSize = sizeF;
            this.documentLength = this.isVertical ? pageSize.getHeight() : pageSize.getWidth();
        } else {
            float length = 0.0f;
            int n = this.pagesCount;
            for (int i = 0; i < n; ++i) {
                SizeF pageSize;
                Intrinsics.checkNotNullExpressionValue((Object)this.pageSizes.get(i), (String)"get(...)");
                length += this.isVertical ? pageSize.getHeight() : pageSize.getWidth();
                if (this.autoSpacing) {
                    Float f = this.pageSpacing.get(i);
                    Intrinsics.checkNotNullExpressionValue((Object)f, (String)"get(...)");
                    length += ((Number)f).floatValue();
                    continue;
                }
                if (i >= this.pagesCount - 1) continue;
                length += (float)this.spacingPx;
            }
            this.documentLength = length;
        }
    }

    private final void preparePagesOffset() {
        this.pageOffsets.clear();
        if (this.singlePageMode) {
            int n = this.pagesCount;
            for (int i = 0; i < n; ++i) {
                this.pageOffsets.add(Float.valueOf(0.0f));
            }
        } else {
            float offset = 0.0f;
            int n = this.pagesCount;
            for (int i = 0; i < n; ++i) {
                SizeF pageSize;
                Intrinsics.checkNotNullExpressionValue((Object)this.pageSizes.get(i), (String)"get(...)");
                float size = this.isVertical ? pageSize.getHeight() : pageSize.getWidth();
                if (this.autoSpacing) {
                    offset += ((Number)this.pageSpacing.get(i)).floatValue() / 2.0f;
                    int n2 = i;
                    if (n2 == 0) {
                        offset -= (float)this.spacingPx / 2.0f;
                    } else if (n2 == this.pagesCount - 1) {
                        offset += (float)this.spacingPx / 2.0f;
                    }
                    this.pageOffsets.add(Float.valueOf(offset));
                    offset += size + ((Number)this.pageSpacing.get(i)).floatValue() / 2.0f;
                    continue;
                }
                this.pageOffsets.add(Float.valueOf(offset));
                offset += size + (float)this.spacingPx;
            }
        }
    }

    public final float getDocLen(float zoom) {
        return this.documentLength * zoom;
    }

    public final float getPageLength(int pageIndex, float zoom) {
        SizeF sizeF = this.getPageSize(pageIndex);
        if (sizeF == null) {
            sizeF = new SizeF(0.0f, 0.0f);
        }
        SizeF size = sizeF;
        return (this.isVertical ? size.getHeight() : size.getWidth()) * zoom;
    }

    public final float getPageSpacing(int pageIndex, float zoom) {
        return (this.autoSpacing ? this.pageSpacing.get(pageIndex) : Float.valueOf(this.spacingPx)).floatValue() * zoom;
    }

    public final float getPageOffset(int pageIndex, float zoom) {
        return this.documentPage(pageIndex) < 0 ? 0.0f : ((Number)this.pageOffsets.get(pageIndex)).floatValue() * zoom;
    }

    public final float getSecondaryPageOffset(int pageIndex, float zoom) {
        float f;
        SizeF sizeF = this.getPageSize(pageIndex);
        if (sizeF == null) {
            sizeF = new SizeF(0.0f, 0.0f);
        }
        SizeF pageSize = sizeF;
        if (this.isVertical) {
            float maxWidth = this.getMaxPageWidth();
            f = zoom * (maxWidth - pageSize.getWidth()) / (float)2;
        } else {
            float maxHeight = this.getMaxPageHeight();
            f = zoom * (maxHeight - pageSize.getHeight()) / (float)2;
        }
        return f;
    }

    public final int getPageAtOffset(float offset, float zoom) {
        float off;
        int currentPage = 0;
        int n = this.pagesCount;
        for (int i = 0; i < n && !((off = ((Number)this.pageOffsets.get(i)).floatValue() * zoom - this.getPageSpacing(i, zoom) / 2.0f) >= offset); ++i) {
            ++currentPage;
        }
        return --currentPage >= 0 ? currentPage : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean openPage(int pageIndex) throws PageRenderingException {
        int docPage = this.documentPage(pageIndex);
        if (docPage < 0) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            boolean bl;
            boolean bl2 = false;
            if (this.openedPages.indexOfKey(docPage) < 0) {
                boolean bl3;
                try {
                    this.pdfiumCore.openPage(docPage);
                    this.openedPages.put(docPage, true);
                    this.openedPageQueue.add(pageIndex);
                    if (this.openedPageQueue.size() > this.maxPageCacheSize) {
                        Integer n;
                        Integer n2 = n = this.openedPageQueue.poll();
                        if (n2 != null) {
                            Intrinsics.checkNotNull((Object)n2);
                            int it = ((Number)n).intValue();
                            boolean bl4 = false;
                            this.closePage(it);
                        }
                    }
                    bl3 = true;
                }
                catch (Exception e) {
                    this.openedPages.put(docPage, false);
                    throw new PageRenderingException(pageIndex, (Throwable)e);
                }
                bl = bl3;
            } else {
                bl = false;
            }
            boolean bl5 = bl;
            return bl5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closePage(int pageIndex) {
        Object object = lock;
        synchronized (object) {
            boolean bl = false;
            if (this.openedPages.indexOfKey(pageIndex) >= 0) {
                this.pdfiumCore.closePage(pageIndex);
                this.openedPages.delete(pageIndex);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean pageHasError(int pageIndex) {
        void key$iv;
        void $this$getOrDefault$iv;
        SparseBooleanArray sparseBooleanArray = this.openedPages;
        int n = this.documentPage(pageIndex);
        boolean defaultValue$iv = false;
        boolean $i$f$getOrDefault = false;
        return !$this$getOrDefault$iv.get((int)key$iv, defaultValue$iv);
    }

    public final void renderPageBitmap(@NotNull Bitmap bitmap, int pageIndex, @NotNull Rect bounds, boolean annotationRendering) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.pdfiumCore.renderPageBitmap(bitmap, this.documentPage(pageIndex), bounds.left, bounds.top, bounds.width(), bounds.height(), annotationRendering);
    }

    @Nullable
    public final Object getMetaData(@NotNull Continuation<? super Meta> $completion) {
        return this.pdfiumCore.getDocumentMeta($completion);
    }

    @Nullable
    public final Object getBookmarks(@NotNull Continuation<? super List<Bookmark>> $completion) {
        return this.pdfiumCore.getTableOfContents($completion);
    }

    @NotNull
    public final List<Link> getPageLinks(int pageIndex) {
        return this.pdfiumCore.getPageLinks(this.documentPage(pageIndex));
    }

    @NotNull
    public final RectF mapRectToDevice(int pageIndex, int startX, int startY, int sizeX, int sizeY, @NotNull RectF rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return this.pdfiumCore.mapPageCoordinateToDevice(this.documentPage(pageIndex), startX, startY, sizeX, sizeY, 0, rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        PdfFile pdfFile2 = this;
        synchronized (pdfFile2) {
            boolean bl = false;
            this.pdfiumCore.close();
            this.originalUserPages = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final int determineValidPageNumberFrom(int userPage) {
        if (userPage <= 0) {
            return 0;
        }
        if (this.originalUserPages != null) {
            List<Integer> list = this.originalUserPages;
            Intrinsics.checkNotNull(list);
            if (userPage >= list.size()) {
                List<Integer> list2 = this.originalUserPages;
                Intrinsics.checkNotNull(list2);
                return list2.size() - 1;
            }
        } else if (userPage >= this.pagesCount) {
            return this.pagesCount - 1;
        }
        return userPage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int documentPage(int userPage) {
        int documentPage;
        int n;
        if (this.originalUserPages != null) {
            if (userPage < 0) return -1;
            List<Integer> list = this.originalUserPages;
            Intrinsics.checkNotNull(list);
            if (userPage >= list.size()) return -1;
            List<Integer> list2 = this.originalUserPages;
            Intrinsics.checkNotNull(list2);
            n = ((Number)list2.get(userPage)).intValue();
        } else {
            n = userPage;
        }
        int n2 = documentPage = n;
        if (0 > n2) return -1;
        if (n2 >= this.pagesCount) return -1;
        boolean bl = true;
        if (!bl) return -1;
        int n3 = documentPage;
        return n3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Lcom/harissk/pdfpreview/PdfFile$Companion;", "", "()V", "lock", "pdfpreview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

