/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview;

import android.graphics.PointF;
import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.harissk.pdfium.Link;
import com.harissk.pdfium.util.SizeF;
import com.harissk.pdfpreview.PDFView;
import com.harissk.pdfpreview.PdfAnimator;
import com.harissk.pdfpreview.PdfFile;
import com.harissk.pdfpreview.model.LinkTapEvent;
import com.harissk.pdfpreview.scroll.ScrollHandle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0015H\u0002J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(J\u0006\u0010*\u001a\u00020(J\b\u0010+\u001a\u00020(H\u0002J\u0018\u0010,\u001a\u00020(2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00101\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J*\u00102\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u00010/2\u0006\u00104\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0010\u00105\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u001bH\u0016J\u0010\u00108\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u001bH\u0016J\u0010\u00109\u001a\u00020(2\u0006\u00107\u001a\u00020\u001bH\u0016J*\u0010:\u001a\u00020\u000b2\b\u00103\u001a\u0004\u0018\u00010/2\u0006\u00104\u001a\u00020/2\u0006\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0015H\u0016J\b\u0010=\u001a\u00020(H\u0002J\u0010\u0010>\u001a\u00020(2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010?\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020/H\u0016J(\u0010E\u001a\u00020(2\u0006\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0011\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/harissk/pdfpreview/DragPinchManager;", "Landroid/view/GestureDetector$OnGestureListener;", "Landroid/view/GestureDetector$OnDoubleTapListener;", "Landroid/view/ScaleGestureDetector$OnScaleGestureListener;", "Landroid/view/View$OnTouchListener;", "pdfView", "Lcom/harissk/pdfpreview/PDFView;", "pdfAnimator", "Lcom/harissk/pdfpreview/PdfAnimator;", "(Lcom/harissk/pdfpreview/PDFView;Lcom/harissk/pdfpreview/PdfAnimator;)V", "enabled", "", "gestureDetector", "Landroid/view/GestureDetector;", "getGestureDetector", "()Landroid/view/GestureDetector;", "gestureDetector$delegate", "Lkotlin/Lazy;", "isScrolling", "()Z", "lastX", "", "lastY", "lastZoomLevel", "lastZoomReloadTime", "", "scaleGestureDetector", "Landroid/view/ScaleGestureDetector;", "getScaleGestureDetector", "()Landroid/view/ScaleGestureDetector;", "scaleGestureDetector$delegate", "scaling", "scrolling", "checkDoPageFling", "velocityX", "velocityY", "checkLinkTapped", "x", "y", "disable", "", "disableLongPress", "enable", "hideHandle", "onBoundedFling", "onDoubleTap", "e", "Landroid/view/MotionEvent;", "onDoubleTapEvent", "onDown", "onFling", "e1", "e2", "onLongPress", "onScale", "detector", "onScaleBegin", "onScaleEnd", "onScroll", "distanceX", "distanceY", "onScrollEnd", "onShowPress", "onSingleTapConfirmed", "onSingleTapUp", "onTouch", "v", "Landroid/view/View;", "event", "startPageFling", "downEvent", "ev", "pdfpreview_release"})
@SourceDebugExtension(value={"SMAP\nDragPinchManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DragPinchManager.kt\ncom/harissk/pdfpreview/DragPinchManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n1#2:346\n*E\n"})
public final class DragPinchManager
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    @NotNull
    private final PDFView pdfView;
    @NotNull
    private final PdfAnimator pdfAnimator;
    @NotNull
    private final Lazy gestureDetector$delegate;
    @NotNull
    private final Lazy scaleGestureDetector$delegate;
    private float lastX;
    private float lastY;
    private float lastZoomLevel;
    private long lastZoomReloadTime;
    private boolean scrolling;
    private boolean scaling;
    private boolean enabled;

    public DragPinchManager(@NotNull PDFView pdfView, @NotNull PdfAnimator pdfAnimator) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfView), (String)"pdfView");
        Intrinsics.checkNotNullParameter((Object)pdfAnimator, (String)"pdfAnimator");
        this.pdfView = pdfView;
        this.pdfAnimator = pdfAnimator;
        this.gestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GestureDetector>(this){
            final /* synthetic */ DragPinchManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GestureDetector invoke() {
                return new GestureDetector(DragPinchManager.access$getPdfView$p(this.this$0).getContext(), (GestureDetector.OnGestureListener)this.this$0);
            }
        }));
        this.scaleGestureDetector$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScaleGestureDetector>(this){
            final /* synthetic */ DragPinchManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ScaleGestureDetector invoke() {
                return new ScaleGestureDetector(DragPinchManager.access$getPdfView$p(this.this$0).getContext(), (ScaleGestureDetector.OnScaleGestureListener)this.this$0);
            }
        }));
        this.lastZoomLevel = 1.0f;
        this.pdfView.setOnTouchListener(this);
    }

    private final GestureDetector getGestureDetector() {
        Lazy lazy = this.gestureDetector$delegate;
        return (GestureDetector)lazy.getValue();
    }

    private final ScaleGestureDetector getScaleGestureDetector() {
        Lazy lazy = this.scaleGestureDetector$delegate;
        return (ScaleGestureDetector)lazy.getValue();
    }

    public final boolean isScrolling() {
        return this.scrolling;
    }

    public final void enable() {
        this.enabled = true;
    }

    public final void disable() {
        this.enabled = false;
    }

    public final void disableLongPress() {
        this.getGestureDetector().setIsLongpressEnabled(false);
    }

    public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.pdfView.callOnTap$pdfpreview_release(e);
        this.checkLinkTapped(e.getX(), e.getY());
        if (!this.pdfView.documentFitsView()) {
            ScrollHandle scrollHandle = this.pdfView.getScrollHandle$pdfpreview_release();
            boolean bl = scrollHandle != null ? scrollHandle.getShown() : false;
            if (bl) {
                ScrollHandle scrollHandle2 = this.pdfView.getScrollHandle$pdfpreview_release();
                if (scrollHandle2 != null) {
                    scrollHandle2.hide();
                }
            } else {
                ScrollHandle scrollHandle3 = this.pdfView.getScrollHandle$pdfpreview_release();
                if (scrollHandle3 != null) {
                    scrollHandle3.show();
                }
            }
        }
        this.pdfView.performClick();
        return true;
    }

    private final boolean checkLinkTapped(float x, float y) {
        PdfFile pdfFile2 = this.pdfView.getPdfFile();
        float mappedX = -this.pdfView.getCurrentXOffset() + x;
        float mappedY = -this.pdfView.getCurrentYOffset() + y;
        int page = pdfFile2.getPageAtOffset(this.pdfView.isSwipeVertical$pdfpreview_release() ? mappedY : mappedX, this.pdfView.getZoom());
        SizeF pageSize = pdfFile2.getScaledPageSize(page, this.pdfView.getZoom());
        int pageX = 0;
        int pageY = 0;
        if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
            pageX = (int)pdfFile2.getSecondaryPageOffset(page, this.pdfView.getZoom());
            pageY = (int)pdfFile2.getPageOffset(page, this.pdfView.getZoom());
        } else {
            pageY = (int)pdfFile2.getSecondaryPageOffset(page, this.pdfView.getZoom());
            pageX = (int)pdfFile2.getPageOffset(page, this.pdfView.getZoom());
        }
        for (Link link : pdfFile2.getPageLinks(page)) {
            RectF mapped = pdfFile2.mapRectToDevice(page, pageX, pageY, (int)pageSize.getWidth(), (int)pageSize.getHeight(), link.getBounds());
            mapped.sort();
            if (!mapped.contains(mappedX, mappedY)) continue;
            this.pdfView.callLinkHandler$pdfpreview_release(new LinkTapEvent(x, y, mappedX, mappedY, mapped, link));
            return true;
        }
        return false;
    }

    private final void startPageFling(MotionEvent downEvent, MotionEvent ev, float velocityX, float velocityY) {
        if (!this.checkDoPageFling(velocityX, velocityY)) {
            return;
        }
        int direction = this.pdfView.isSwipeVertical$pdfpreview_release() ? (velocityY > 0.0f ? -1 : 1) : (velocityX > 0.0f ? -1 : 1);
        float delta = this.pdfView.isSwipeVertical$pdfpreview_release() ? ev.getY() - downEvent.getY() : ev.getX() - downEvent.getX();
        float offsetX = this.pdfView.getCurrentXOffset() - delta * this.pdfView.getZoom();
        float offsetY = this.pdfView.getCurrentYOffset() - delta * this.pdfView.getZoom();
        int startingPage = this.pdfView.findFocusPage$pdfpreview_release(offsetX, offsetY);
        int targetPage = Math.max(0, Math.min(this.pdfView.getPageCount() - 1, startingPage + direction));
        this.pdfAnimator.flingToPage(-this.pdfView.snapOffsetForPage$pdfpreview_release(targetPage, this.pdfView.findSnapEdge$pdfpreview_release(targetPage)));
    }

    public boolean onDoubleTap(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.pdfView.isDoubleTapEnabled$pdfpreview_release()) {
            return false;
        }
        if (this.pdfView.getZoom() < this.pdfView.getMidZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMidZoom());
        } else if (this.pdfView.getZoom() < this.pdfView.getMaxZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMaxZoom());
        } else {
            this.pdfView.resetZoomWithAnimation$pdfpreview_release();
        }
        return true;
    }

    public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return false;
    }

    public boolean onDown(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.pdfAnimator.cancelFling();
        return true;
    }

    public void onShowPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return false;
    }

    public boolean onScroll(@Nullable MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        this.scrolling = true;
        if (this.pdfView.isZooming$pdfpreview_release() || this.pdfView.isSwipeEnabled()) {
            this.pdfView.moveRelativeTo(-distanceX, -distanceY);
        }
        return true;
    }

    private final void onScrollEnd() {
        this.pdfView.updateScrollUIElements$pdfpreview_release();
        this.pdfView.loadPages$pdfpreview_release();
        this.hideHandle();
        if (!this.pdfAnimator.isFlinging()) {
            this.pdfView.performPageSnap$pdfpreview_release();
        }
    }

    public void onLongPress(@NotNull MotionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.pdfView.callOnLongPress$pdfpreview_release(e);
    }

    public boolean onFling(@Nullable MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        if (!this.pdfView.isSwipeEnabled()) {
            return false;
        }
        if (this.pdfView.isPageFlingEnabled$pdfpreview_release()) {
            if (this.pdfView.pageFillsScreen$pdfpreview_release()) {
                this.onBoundedFling(velocityX, velocityY);
            } else {
                MotionEvent motionEvent = e1;
                if (motionEvent != null) {
                    MotionEvent it = motionEvent;
                    boolean bl = false;
                    this.startPageFling(it, e2, velocityX, velocityY);
                }
            }
        } else {
            this.pdfAnimator.animateFling((int)this.pdfView.getCurrentXOffset(), (int)this.pdfView.getCurrentYOffset(), (int)velocityX, (int)velocityY, (int)(this.pdfView.isSwipeVertical$pdfpreview_release() ? -(this.pdfView.toCurrentScale$pdfpreview_release(this.pdfView.getPdfFile().getMaxPageWidth()) - (float)this.pdfView.getWidth()) : -(this.pdfView.getPdfFile().getDocLen(this.pdfView.getZoom()) - (float)this.pdfView.getWidth())), 0, (int)(this.pdfView.isSwipeVertical$pdfpreview_release() ? -(this.pdfView.getPdfFile().getDocLen(this.pdfView.getZoom()) - (float)this.pdfView.getHeight()) : -(this.pdfView.toCurrentScale$pdfpreview_release(this.pdfView.getPdfFile().getMaxPageHeight()) - (float)this.pdfView.getHeight())), 0);
        }
        return true;
    }

    private final void onBoundedFling(float velocityX, float velocityY) {
        float xOffset = this.pdfView.getCurrentXOffset();
        float yOffset = this.pdfView.getCurrentYOffset();
        float mappedX = -xOffset + this.lastX;
        float mappedY = -yOffset + this.lastY;
        int page = this.pdfView.getPdfFile().getPageAtOffset(this.pdfView.isSwipeVertical$pdfpreview_release() ? mappedY : mappedX, this.pdfView.getZoom());
        float pageStart = -this.pdfView.getPdfFile().getPageOffset(page, this.pdfView.getZoom());
        float pageEnd = pageStart - this.pdfView.getPdfFile().getPageLength(page, this.pdfView.getZoom());
        float minX = 0.0f;
        float minY = 0.0f;
        float maxX = 0.0f;
        float maxY = 0.0f;
        if (this.pdfView.isSwipeVertical$pdfpreview_release()) {
            minX = -(this.pdfView.toCurrentScale$pdfpreview_release(this.pdfView.getPdfFile().getMaxPageWidth()) - (float)this.pdfView.getWidth());
            minY = pageEnd + (float)this.pdfView.getHeight();
            maxX = 0.0f;
            maxY = pageStart;
        } else {
            minX = pageEnd + (float)this.pdfView.getWidth();
            minY = -(this.pdfView.toCurrentScale$pdfpreview_release(this.pdfView.getPdfFile().getMaxPageHeight()) - (float)this.pdfView.getHeight());
            maxX = pageStart;
            maxY = 0.0f;
        }
        this.pdfAnimator.animateFling((int)xOffset, (int)yOffset, (int)velocityX, (int)velocityY, (int)minX, (int)maxX, (int)minY, (int)maxY);
    }

    public boolean onScale(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        float wantedZoom = this.pdfView.getZoom() * detector.getScaleFactor();
        float minZoom = RangesKt.coerceAtMost((float)this.pdfView.getPdfViewerConfiguration().getMinZoom(), (float)this.pdfView.getMinZoom());
        float maxZoom = RangesKt.coerceAtMost((float)this.pdfView.getPdfViewerConfiguration().getMaxZoom(), (float)this.pdfView.getMaxZoom());
        this.pdfView.zoomCenteredRelativeTo(RangesKt.coerceIn((float)wantedZoom, (float)minZoom, (float)maxZoom) / this.pdfView.getZoom(), new PointF(detector.getFocusX(), detector.getFocusY()));
        long currentTime = System.currentTimeMillis();
        float zoomChange = Math.abs(this.pdfView.getZoom() - this.lastZoomLevel) / this.lastZoomLevel;
        if (zoomChange > 0.2f && currentTime - this.lastZoomReloadTime > 200L) {
            this.lastZoomLevel = this.pdfView.getZoom();
            this.lastZoomReloadTime = currentTime;
            this.pdfView.loadPages$pdfpreview_release();
        }
        return true;
    }

    public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.scaling = true;
        this.lastZoomLevel = this.pdfView.getZoom();
        this.lastZoomReloadTime = System.currentTimeMillis();
        return true;
    }

    public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
        Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
        this.scaling = false;
        float finalZoom = this.pdfView.getZoom();
        this.pdfView.loadPages$pdfpreview_release();
        this.hideHandle();
        this.pdfView.zoomTo$pdfpreview_release(finalZoom);
        this.pdfView.notifyZoomChanged$pdfpreview_release(finalZoom, this.lastZoomLevel);
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.enabled) {
            return false;
        }
        boolean isGestureEvent = this.getGestureDetector().onTouchEvent(event);
        boolean isScaleGestureEvent = this.getScaleGestureDetector().onTouchEvent(event);
        this.lastX = event.getX();
        this.lastY = event.getY();
        if (event.getAction() == 1 && this.scrolling) {
            this.scrolling = false;
            this.onScrollEnd();
        }
        return isGestureEvent || isScaleGestureEvent;
    }

    private final void hideHandle() {
        block1: {
            ScrollHandle scrollHandle = this.pdfView.getScrollHandle$pdfpreview_release();
            boolean bl = scrollHandle != null ? scrollHandle.getShown() : false;
            if (!bl) break block1;
            ScrollHandle scrollHandle2 = this.pdfView.getScrollHandle$pdfpreview_release();
            if (scrollHandle2 != null) {
                scrollHandle2.hideDelayed();
            }
        }
    }

    private final boolean checkDoPageFling(float velocityX, float velocityY) {
        return this.pdfView.isSwipeVertical$pdfpreview_release() ? Math.abs(velocityY) > Math.abs(velocityX) : Math.abs(velocityX) > Math.abs(velocityY);
    }

    public static final /* synthetic */ PDFView access$getPdfView$p(DragPinchManager $this) {
        return $this.pdfView;
    }
}

