/*
 * Decompiled with CFR 0.152.
 */
package com.harissk.pdfpreview;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.util.LruCache;
import com.harissk.pdfpreview.model.PagePart;
import com.harissk.pdfpreview.request.PdfViewerConfiguration;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u001eJ\b\u0010 \u001a\u00020\u0014H\u0002J\u0006\u0010!\u001a\u00020\u0014J\u0006\u0010\"\u001a\u00020\u0014J\u001e\u0010#\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0012R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u000e\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/harissk/pdfpreview/CacheManager;", "", "pdfViewerConfiguration", "Lcom/harissk/pdfpreview/request/PdfViewerConfiguration;", "(Lcom/harissk/pdfpreview/request/PdfViewerConfiguration;)V", "activeCache", "Ljava/util/PriorityQueue;", "Lcom/harissk/pdfpreview/model/PagePart;", "getActiveCache", "()Ljava/util/PriorityQueue;", "activeCache$delegate", "Lkotlin/Lazy;", "passiveActiveLock", "passiveCache", "getPassiveCache", "passiveCache$delegate", "thumbnails", "Landroid/util/LruCache;", "", "cachePart", "", "part", "cacheThumbnail", "clearPageCache", "page", "containsThumbnail", "", "bounds", "Landroid/graphics/RectF;", "getPageParts", "", "getThumbnails", "makeAFreeSpace", "makeANewSet", "recycle", "upPartIfContained", "pageRelativeBounds", "toOrder", "Companion", "pdfpreview_release"})
@SourceDebugExtension(value={"SMAP\nCacheManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheManager.kt\ncom/harissk/pdfpreview/CacheManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n288#2,2:148\n288#2,2:150\n1855#2,2:152\n1855#2,2:154\n*S KotlinDebug\n*F\n+ 1 CacheManager.kt\ncom/harissk/pdfpreview/CacheManager\n*L\n95#1:148,2\n100#1:150,2\n137#1:152,2\n139#1:154,2\n*E\n"})
public final class CacheManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PdfViewerConfiguration pdfViewerConfiguration;
    @NotNull
    private final Lazy passiveCache$delegate;
    @NotNull
    private final Lazy activeCache$delegate;
    @NotNull
    private final LruCache<Integer, PagePart> thumbnails;
    @NotNull
    private final Object passiveActiveLock;
    @NotNull
    private static final Comparator<PagePart> PAGE_PART_COMPARATOR = CacheManager::PAGE_PART_COMPARATOR$lambda$12;

    public CacheManager(@NotNull PdfViewerConfiguration pdfViewerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)pdfViewerConfiguration, (String)"pdfViewerConfiguration");
        this.pdfViewerConfiguration = pdfViewerConfiguration;
        this.passiveCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PriorityQueue<PagePart>>(this){
            final /* synthetic */ CacheManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PriorityQueue<PagePart> invoke() {
                return new PriorityQueue<PagePart>(CacheManager.access$getPdfViewerConfiguration$p(this.this$0).getMaxCachedBitmaps(), CacheManager.access$getCompanion$p().getPAGE_PART_COMPARATOR());
            }
        }));
        this.activeCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PriorityQueue<PagePart>>(this){
            final /* synthetic */ CacheManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PriorityQueue<PagePart> invoke() {
                return new PriorityQueue<PagePart>(CacheManager.access$getPdfViewerConfiguration$p(this.this$0).getMaxCachedBitmaps(), CacheManager.access$getCompanion$p().getPAGE_PART_COMPARATOR());
            }
        }));
        this.thumbnails = new LruCache(this.pdfViewerConfiguration.getMaxCachedThumbnails());
        this.passiveActiveLock = new Object();
    }

    private final PriorityQueue<PagePart> getPassiveCache() {
        Lazy lazy = this.passiveCache$delegate;
        return (PriorityQueue)lazy.getValue();
    }

    private final PriorityQueue<PagePart> getActiveCache() {
        Lazy lazy = this.activeCache$delegate;
        return (PriorityQueue)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cachePart(@NotNull PagePart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Bitmap bitmap = part.getRenderedBitmap();
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        Object object = this.passiveActiveLock;
        synchronized (object) {
            boolean bl = false;
            this.makeAFreeSpace();
            boolean bl2 = this.getActiveCache().offer(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void makeANewSet() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            boolean bl = false;
            this.getPassiveCache().addAll((Collection<PagePart>)this.getActiveCache());
            this.getActiveCache().clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void makeAFreeSpace() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            boolean bl = false;
            while (this.getActiveCache().size() + this.getPassiveCache().size() >= this.pdfViewerConfiguration.getMaxCachedBitmaps()) {
                PagePart pagePart = this.getPassiveCache().poll();
                if (pagePart != null && (pagePart = pagePart.getRenderedBitmap()) != null) {
                    pagePart.recycle();
                    continue;
                }
                PagePart pagePart2 = this.getActiveCache().poll();
                if (pagePart2 == null || (pagePart2 = pagePart2.getRenderedBitmap()) == null) continue;
                pagePart2.recycle();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void cacheThumbnail(@NotNull PagePart part) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Bitmap bitmap = part.getRenderedBitmap();
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        this.thumbnails.put((Object)part.getPage(), (Object)part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean upPartIfContained(int page, @NotNull RectF pageRelativeBounds, int toOrder) {
        Intrinsics.checkNotNullParameter((Object)pageRelativeBounds, (String)"pageRelativeBounds");
        PagePart fakePart = new PagePart(page, null, pageRelativeBounds, false, 0);
        Object object = this.passiveActiveLock;
        synchronized (object) {
            block10: {
                Object v1;
                block9: {
                    block8: {
                        Object v0;
                        block7: {
                            boolean bl = false;
                            Iterable $this$firstOrNull$iv = this.getActiveCache();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                PagePart it = (PagePart)element$iv;
                                boolean bl2 = false;
                                if (!(it.getPage() == fakePart.getPage() && Intrinsics.areEqual((Object)it.getPageRelativeBounds(), (Object)fakePart.getPageRelativeBounds()))) continue;
                                v0 = element$iv;
                                break block7;
                            }
                            v0 = null;
                        }
                        PagePart partInActiveCache = v0;
                        if (partInActiveCache == null) break block8;
                        boolean bl = true;
                        return bl;
                    }
                    Iterable $this$firstOrNull$iv = this.getPassiveCache();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PagePart it = (PagePart)element$iv;
                        boolean bl = false;
                        if (!(it.getPage() == fakePart.getPage() && Intrinsics.areEqual((Object)it.getPageRelativeBounds(), (Object)fakePart.getPageRelativeBounds()))) continue;
                        v1 = element$iv;
                        break block9;
                    }
                    v1 = null;
                }
                PagePart partInPassiveCache = v1;
                if (partInPassiveCache == null) break block10;
                this.getPassiveCache().remove(partInPassiveCache);
                this.getPassiveCache().offer(PagePart.copy$default(fakePart, 0, null, null, false, toOrder, 15, null));
                boolean bl = true;
                return bl;
            }
            Unit unit = Unit.INSTANCE;
        }
        return false;
    }

    public final boolean containsThumbnail(int page, @NotNull RectF bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        PagePart pagePart = (PagePart)this.thumbnails.get((Object)page);
        if (pagePart == null) {
            return false;
        }
        PagePart cachedThumbnail = pagePart;
        return Intrinsics.areEqual((Object)cachedThumbnail.getPageRelativeBounds(), (Object)bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearPageCache(int page) {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            boolean bl = false;
            CollectionsKt.removeAll((Iterable)this.getActiveCache(), (Function1)((Function1)new Function1<PagePart, Boolean>(page){
                final /* synthetic */ int $page;
                {
                    this.$page = $page;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(PagePart it) {
                    return it.getPage() == this.$page;
                }
            }));
            boolean bl2 = CollectionsKt.removeAll((Iterable)this.getPassiveCache(), (Function1)((Function1)new Function1<PagePart, Boolean>(page){
                final /* synthetic */ int $page;
                {
                    this.$page = $page;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(PagePart it) {
                    return it.getPage() == this.$page;
                }
            }));
        }
        this.thumbnails.remove((Object)page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PagePart> getPageParts() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            List list;
            boolean bl = false;
            List $this$getPageParts_u24lambda_u248_u24lambda_u247 = list = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            $this$getPageParts_u24lambda_u248_u24lambda_u247.addAll((Collection)this.getPassiveCache());
            $this$getPageParts_u24lambda_u248_u24lambda_u247.addAll((Collection)this.getActiveCache());
            List list2 = CollectionsKt.build((List)list);
            return list2;
        }
    }

    @NotNull
    public final List<PagePart> getThumbnails() {
        return CollectionsKt.toList((Iterable)this.thumbnails.snapshot().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recycle() {
        Object object = this.passiveActiveLock;
        synchronized (object) {
            PagePart it;
            boolean bl = false;
            Iterable $this$forEach$iv = this.getPassiveCache();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PagePart)element$iv;
                boolean bl2 = false;
                Bitmap bitmap = it.getRenderedBitmap();
                if (bitmap == null) continue;
                bitmap.recycle();
            }
            this.getPassiveCache().clear();
            $this$forEach$iv = this.getActiveCache();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PagePart)element$iv;
                boolean bl3 = false;
                Bitmap bitmap = it.getRenderedBitmap();
                if (bitmap == null) continue;
                bitmap.recycle();
            }
            this.getActiveCache().clear();
            Unit unit = Unit.INSTANCE;
        }
        this.thumbnails.evictAll();
    }

    private static final int PAGE_PART_COMPARATOR$lambda$12(PagePart part1, PagePart part2) {
        PagePart pagePart = part1;
        PagePart pagePart2 = part2;
        return Intrinsics.compare((int)(pagePart != null ? pagePart.getCacheOrder() : 0), (int)(pagePart2 != null ? pagePart2.getCacheOrder() : 0));
    }

    public static final /* synthetic */ PdfViewerConfiguration access$getPdfViewerConfiguration$p(CacheManager $this) {
        return $this.pdfViewerConfiguration;
    }

    public static final /* synthetic */ Companion access$getCompanion$p() {
        return Companion;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/harissk/pdfpreview/CacheManager$Companion;", "", "()V", "PAGE_PART_COMPARATOR", "Ljava/util/Comparator;", "Lcom/harissk/pdfpreview/model/PagePart;", "getPAGE_PART_COMPARATOR", "()Ljava/util/Comparator;", "pdfpreview_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Comparator<PagePart> getPAGE_PART_COMPARATOR() {
            return PAGE_PART_COMPARATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

