/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Supplier;

public interface VavrRateLimiter {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(RateLimiter rateLimiter, CheckedFunction0<T> supplier) {
        return VavrRateLimiter.decorateCheckedSupplier(rateLimiter, 1, supplier);
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(RateLimiter rateLimiter, int permits, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            RateLimiter.waitForPermission((RateLimiter)rateLimiter, (int)permits);
            try {
                Object result = supplier.apply();
                rateLimiter.onResult(result);
                return result;
            }
            catch (Exception exception) {
                rateLimiter.onError((Throwable)exception);
                throw exception;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(RateLimiter rateLimiter, CheckedRunnable runnable) {
        return VavrRateLimiter.decorateCheckedRunnable(rateLimiter, 1, runnable);
    }

    public static CheckedRunnable decorateCheckedRunnable(RateLimiter rateLimiter, int permits, CheckedRunnable runnable) {
        return () -> {
            RateLimiter.waitForPermission((RateLimiter)rateLimiter, (int)permits);
            try {
                runnable.run();
                rateLimiter.onSuccess();
            }
            catch (Exception exception) {
                rateLimiter.onError((Throwable)exception);
                throw exception;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, CheckedFunction1<T, R> function) {
        return VavrRateLimiter.decorateCheckedFunction(rateLimiter, 1, function);
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, int permits, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> VavrRateLimiter.decorateCheckedSupplier(rateLimiter, permits, (CheckedFunction0 & Serializable)() -> function.apply(t)).apply();
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, Function<T, Integer> permitsCalculator, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> VavrRateLimiter.decorateCheckedFunction(rateLimiter, (Integer)permitsCalculator.apply(t), function).apply(t);
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(RateLimiter rateLimiter, Supplier<Try<T>> supplier) {
        return VavrRateLimiter.decorateTrySupplier(rateLimiter, 1, supplier);
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(RateLimiter rateLimiter, int permits, Supplier<Try<T>> supplier) {
        return () -> {
            try {
                RateLimiter.waitForPermission((RateLimiter)rateLimiter, (int)permits);
                try {
                    Try result = (Try)supplier.get();
                    if (result.isSuccess()) {
                        rateLimiter.onResult(result.get());
                    } else {
                        rateLimiter.onError(result.getCause());
                    }
                    return result;
                }
                catch (Exception exception) {
                    rateLimiter.onError((Throwable)exception);
                    throw exception;
                }
            }
            catch (RequestNotPermitted requestNotPermitted) {
                return Try.failure((Throwable)requestNotPermitted);
            }
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(RateLimiter rateLimiter, Supplier<Either<? extends Exception, T>> supplier) {
        return VavrRateLimiter.decorateEitherSupplier(rateLimiter, 1, supplier);
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(RateLimiter rateLimiter, int permits, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            try {
                RateLimiter.waitForPermission((RateLimiter)rateLimiter, (int)permits);
                try {
                    Either result = (Either)supplier.get();
                    if (result.isRight()) {
                        rateLimiter.onResult(result.get());
                    } else {
                        rateLimiter.onError((Throwable)result.getLeft());
                    }
                    return Either.narrow((Either)result);
                }
                catch (Exception exception) {
                    rateLimiter.onError((Throwable)exception);
                    throw exception;
                }
            }
            catch (RequestNotPermitted requestNotPermitted) {
                return Either.left((Object)((Object)requestNotPermitted));
            }
        };
    }

    public static <T> Try<T> executeTrySupplier(RateLimiter rateLimiter, Supplier<Try<T>> supplier) {
        return VavrRateLimiter.executeTrySupplier(rateLimiter, 1, supplier);
    }

    public static <T> Try<T> executeTrySupplier(RateLimiter rateLimiter, int permits, Supplier<Try<T>> supplier) {
        return VavrRateLimiter.decorateTrySupplier(rateLimiter, permits, supplier).get();
    }

    public static <T> Either<Exception, T> executeEitherSupplier(RateLimiter rateLimiter, Supplier<Either<? extends Exception, T>> supplier) {
        return VavrRateLimiter.executeEitherSupplier(rateLimiter, 1, supplier);
    }

    public static <T> Either<Exception, T> executeEitherSupplier(RateLimiter rateLimiter, int permits, Supplier<Either<? extends Exception, T>> supplier) {
        return VavrRateLimiter.decorateEitherSupplier(rateLimiter, permits, supplier).get();
    }

    public static <T> T executeCheckedSupplier(RateLimiter rateLimiter, CheckedFunction0<T> checkedSupplier) throws Throwable {
        return VavrRateLimiter.executeCheckedSupplier(rateLimiter, 1, checkedSupplier);
    }

    public static <T> T executeCheckedSupplier(RateLimiter rateLimiter, int permits, CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)VavrRateLimiter.decorateCheckedSupplier(rateLimiter, permits, checkedSupplier).apply();
    }
}

