/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry;

import io.github.resilience4j.retry.Retry;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.function.Supplier;

public interface VavrRetry {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Retry retry, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            Retry.Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = supplier.apply())) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Retry retry, CheckedRunnable runnable) {
        return () -> {
            Retry.Context context = retry.context();
            while (true) {
                try {
                    runnable.run();
                    context.onComplete();
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Retry retry, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            Retry.Context context = retry.context();
            while (true) {
                try {
                    Object result;
                    boolean validationOfResult;
                    while (validationOfResult = context.onResult(result = function.apply(t))) {
                    }
                    context.onComplete();
                    return result;
                }
                catch (Exception exception) {
                    context.onError(exception);
                    continue;
                }
                break;
            }
        };
    }

    public static <E extends Exception, T> Supplier<Either<E, T>> decorateEitherSupplier(Retry retry, Supplier<Either<E, T>> supplier) {
        return () -> {
            Retry.Context context = retry.context();
            while (true) {
                Either result;
                if ((result = (Either)supplier.get()).isRight()) {
                    boolean validationOfResult = context.onResult(result.get());
                    if (validationOfResult) continue;
                    context.onComplete();
                    return result;
                }
                Exception exception = (Exception)result.getLeft();
                try {
                    context.onError((Exception)result.getLeft());
                }
                catch (Exception e) {
                    return Either.left((Object)exception);
                }
            }
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(Retry retry, Supplier<Try<T>> supplier) {
        return () -> {
            Try result;
            Retry.Context context = retry.context();
            while (true) {
                if ((result = (Try)supplier.get()).isSuccess()) {
                    boolean validationOfResult = context.onResult(result.get());
                    if (validationOfResult) continue;
                    context.onComplete();
                    return result;
                }
                Throwable cause = result.getCause();
                if (!(cause instanceof Exception)) break;
                try {
                    context.onError((Exception)result.getCause());
                }
                catch (Exception e) {
                    return result;
                }
            }
            return result;
        };
    }

    public static <T> T executeCheckedSupplier(Retry retry, CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)VavrRetry.decorateCheckedSupplier(retry, checkedSupplier).apply();
    }

    public static <E extends Exception, T> Either<E, T> executeEitherSupplier(Retry retry, Supplier<Either<E, T>> supplier) {
        return VavrRetry.decorateEitherSupplier(retry, supplier).get();
    }

    public static <T> Try<T> executeTrySupplier(Retry retry, Supplier<Try<T>> supplier) {
        return VavrRetry.decorateTrySupplier(retry, supplier).get();
    }
}

