/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import io.github.resilience4j.metrics.Timer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import java.io.Serializable;

public interface VavrTimer {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Timer timer, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            Timer.Context context = timer.context();
            try {
                Object returnValue = supplier.apply();
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Timer timer, CheckedRunnable runnable) {
        return () -> {
            Timer.Context context = timer.context();
            try {
                runnable.run();
                context.onSuccess();
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Timer timer, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            Timer.Context context = timer.context();
            try {
                Object returnValue = function.apply(t);
                context.onSuccess();
                return returnValue;
            }
            catch (Throwable e) {
                context.onError();
                throw e;
            }
        };
    }
}

