/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter;

import java.time.Duration;
import java.util.Objects;

public class TimeLimiterConfig {
    private static final String TIMEOUT_DURATION_MUST_NOT_BE_NULL = "TimeoutDuration must not be null";
    private Duration timeoutDuration = Duration.ofSeconds(1L);
    private boolean cancelRunningFuture = true;

    private TimeLimiterConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static TimeLimiterConfig ofDefaults() {
        return new Builder().build();
    }

    private static Duration checkTimeoutDuration(Duration timeoutDuration) {
        return Objects.requireNonNull(timeoutDuration, TIMEOUT_DURATION_MUST_NOT_BE_NULL);
    }

    public Duration getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public boolean shouldCancelRunningFuture() {
        return this.cancelRunningFuture;
    }

    public String toString() {
        return "TimeLimiterConfig{timeoutDuration=" + this.timeoutDuration + "cancelRunningFuture=" + this.cancelRunningFuture + '}';
    }

    public static class Builder {
        private TimeLimiterConfig config = new TimeLimiterConfig();

        public TimeLimiterConfig build() {
            return this.config;
        }

        public Builder timeoutDuration(Duration timeoutDuration) {
            this.config.timeoutDuration = TimeLimiterConfig.checkTimeoutDuration(timeoutDuration);
            return this;
        }

        public Builder cancelRunningFuture(boolean cancelRunningFuture) {
            this.config.cancelRunningFuture = cancelRunningFuture;
            return this;
        }
    }
}

