/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.timelimiter.configure;

import io.github.resilience4j.rxjava3.timelimiter.transformer.TimeLimiterTransformer;
import io.github.resilience4j.spring6.timelimiter.configure.IllegalReturnTypeException;
import io.github.resilience4j.spring6.timelimiter.configure.TimeLimiterAspectExt;
import io.github.resilience4j.spring6.utils.AspectUtil;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;

public class RxJava3TimeLimiterAspectExt
implements TimeLimiterAspectExt {
    private final Set<Class<?>> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class<?> returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, TimeLimiter timeLimiter, String methodName) throws Throwable {
        TimeLimiterTransformer timeLimiterTransformer = TimeLimiterTransformer.of((TimeLimiter)timeLimiter);
        Object returnValue = proceedingJoinPoint.proceed();
        return RxJava3TimeLimiterAspectExt.executeRxJava3Aspect(timeLimiterTransformer, returnValue, methodName);
    }

    private static Object executeRxJava3Aspect(TimeLimiterTransformer timeLimiterTransformer, Object returnValue, String methodName) {
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.compose((ObservableTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.compose((SingleTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.compose((CompletableTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.compose((MaybeTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.compose((FlowableTransformer)timeLimiterTransformer);
        }
        throw new IllegalReturnTypeException(returnValue.getClass(), methodName, "RxJava3 expects Flowable/Single/...");
    }
}

