/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.spring6.micrometer.configure;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.reactor.micrometer.operator.TimerOperator;
import io.github.resilience4j.spring6.micrometer.configure.TimerAspectExt;
import io.github.resilience4j.spring6.timelimiter.configure.IllegalReturnTypeException;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorTimerAspectExt
implements TimerAspectExt {
    @Override
    public boolean canHandleReturnType(Class<?> returnType) {
        return Flux.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, Timer timer, String methodName) throws Throwable {
        Object returnValue = proceedingJoinPoint.proceed();
        if (Flux.class.isAssignableFrom(returnValue.getClass())) {
            Flux fluxReturnValue = (Flux)returnValue;
            return fluxReturnValue.transformDeferred((Function)TimerOperator.of((Timer)timer));
        }
        if (Mono.class.isAssignableFrom(returnValue.getClass())) {
            Mono monoReturnValue = (Mono)returnValue;
            return monoReturnValue.transformDeferred((Function)TimerOperator.of((Timer)timer));
        }
        throw new IllegalReturnTypeException(returnValue.getClass(), methodName, "Reactor expects Mono/Flux.");
    }
}

