/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspectExt;
import io.github.resilience4j.rxjava3.ratelimiter.operator.RateLimiterOperator;
import io.github.resilience4j.utils.AspectUtil;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.CompletableTransformer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.MaybeTransformer;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.core.SingleTransformer;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxJava3RateLimiterAspectExt
implements RateLimiterAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(RxJava3RateLimiterAspectExt.class);
    private final Set<Class> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter, String methodName) throws Throwable {
        RateLimiterOperator rateLimiterOperator = RateLimiterOperator.of((RateLimiter)rateLimiter);
        Object returnValue = proceedingJoinPoint.proceed();
        return this.executeRxJava3Aspect(rateLimiterOperator, returnValue);
    }

    private Object executeRxJava3Aspect(RateLimiterOperator rateLimiterOperator, Object returnValue) {
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.compose((ObservableTransformer)rateLimiterOperator);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.compose((SingleTransformer)rateLimiterOperator);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.compose((CompletableTransformer)rateLimiterOperator);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.compose((MaybeTransformer)rateLimiterOperator);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.compose((FlowableTransformer)rateLimiterOperator);
        }
        logger.error("Unsupported type for Rate limiter RxJava3 {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the Rate limiter in RxJava3 :" + returnValue.getClass().getName());
    }
}

