/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.fallback;

import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.spelresolver.SpelResolver;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FallbackExecutor {
    private static final Logger logger = LoggerFactory.getLogger(FallbackExecutor.class);
    private final SpelResolver spelResolver;
    private final FallbackDecorators fallbackDecorators;

    public FallbackExecutor(SpelResolver spelResolver, FallbackDecorators fallbackDecorators) {
        this.spelResolver = spelResolver;
        this.fallbackDecorators = fallbackDecorators;
    }

    public Object execute(ProceedingJoinPoint proceedingJoinPoint, Method method, String fallbackMethodValue, CheckedSupplier<Object> primaryFunction) throws Throwable {
        String fallbackMethodName = this.spelResolver.resolve(method, proceedingJoinPoint.getArgs(), fallbackMethodValue);
        FallbackMethod fallbackMethod = null;
        if (StringUtils.hasLength((String)fallbackMethodName)) {
            try {
                fallbackMethod = FallbackMethod.create(fallbackMethodName, method, proceedingJoinPoint.getArgs(), proceedingJoinPoint.getTarget(), proceedingJoinPoint.getThis());
            }
            catch (NoSuchMethodException ex) {
                logger.warn("No fallback method match found", (Throwable)ex);
            }
        }
        if (fallbackMethod == null) {
            return primaryFunction.get();
        }
        return this.fallbackDecorators.decorate(fallbackMethod, primaryFunction).get();
    }
}

