/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure.threadpool;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolBulkheadConfigCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.ThreadPoolBulkheadConfigurationProperties;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class ThreadPoolBulkheadConfiguration {
    @Bean
    @Qualifier(value="compositeThreadPoolBulkheadCustomizer")
    public CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer(@Autowired(required=false) List<ThreadPoolBulkheadConfigCustomizer> customizers) {
        return new CompositeCustomizer(customizers);
    }

    @Bean
    public ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry(ThreadPoolBulkheadConfigurationProperties bulkheadConfigurationProperties, EventConsumerRegistry<BulkheadEvent> bulkheadEventConsumerRegistry, RegistryEventConsumer<ThreadPoolBulkhead> threadPoolBulkheadRegistryEventConsumer, @Qualifier(value="compositeThreadPoolBulkheadCustomizer") CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer) {
        ThreadPoolBulkheadRegistry bulkheadRegistry = this.createBulkheadRegistry(bulkheadConfigurationProperties, threadPoolBulkheadRegistryEventConsumer, compositeThreadPoolBulkheadCustomizer);
        this.registerEventConsumer(bulkheadRegistry, bulkheadEventConsumerRegistry, bulkheadConfigurationProperties);
        bulkheadConfigurationProperties.getBackends().forEach((name, properties) -> bulkheadRegistry.bulkhead(name, bulkheadConfigurationProperties.createThreadPoolBulkheadConfig(name, compositeThreadPoolBulkheadCustomizer)));
        return bulkheadRegistry;
    }

    @Bean
    @Primary
    public RegistryEventConsumer<ThreadPoolBulkhead> threadPoolBulkheadRegistryEventConsumer(Optional<List<RegistryEventConsumer<ThreadPoolBulkhead>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private ThreadPoolBulkheadRegistry createBulkheadRegistry(ThreadPoolBulkheadConfigurationProperties threadPoolBulkheadConfigurationProperties, RegistryEventConsumer<ThreadPoolBulkhead> threadPoolBulkheadRegistryEventConsumer, CompositeCustomizer<ThreadPoolBulkheadConfigCustomizer> compositeThreadPoolBulkheadCustomizer) {
        java.util.Map<String, ThreadPoolBulkheadConfig> configs = threadPoolBulkheadConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> threadPoolBulkheadConfigurationProperties.createThreadPoolBulkheadConfig((ThreadPoolBulkheadConfigurationProperties.InstanceProperties)entry.getValue(), compositeThreadPoolBulkheadCustomizer, (String)entry.getKey())));
        return ThreadPoolBulkheadRegistry.of(configs, threadPoolBulkheadRegistryEventConsumer, (Map)HashMap.ofAll((java.util.Map)threadPoolBulkheadConfigurationProperties.getTags()));
    }

    private void registerEventConsumer(ThreadPoolBulkheadRegistry bulkheadRegistry, EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry, ThreadPoolBulkheadConfigurationProperties properties) {
        bulkheadRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (ThreadPoolBulkhead)event.getAddedEntry(), properties)).onEntryReplaced(event -> this.registerEventConsumer(eventConsumerRegistry, (ThreadPoolBulkhead)event.getNewEntry(), properties));
    }

    private void registerEventConsumer(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry, ThreadPoolBulkhead bulkHead, ThreadPoolBulkheadConfigurationProperties bulkheadConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(bulkheadConfigurationProperties.getBackendProperties(bulkHead.getName())).map(ThreadPoolBulkheadConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        bulkHead.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(String.join((CharSequence)"-", ThreadPoolBulkhead.class.getSimpleName(), bulkHead.getName()), eventConsumerBufferSize));
    }
}

