/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.configure;

import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.configure.TimeLimiterConfigurationProperties;
import io.github.resilience4j.utils.AnnotationExtractor;
import io.github.resilience4j.utils.ValueResolver;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Aspect
public class TimeLimiterAspect
implements EmbeddedValueResolverAware,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(TimeLimiterAspect.class);
    private final TimeLimiterRegistry timeLimiterRegistry;
    private final TimeLimiterConfigurationProperties properties;
    private static final ScheduledExecutorService timeLimiterExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    @Nullable
    private final List<TimeLimiterAspectExt> timeLimiterAspectExtList;
    private final FallbackDecorators fallbackDecorators;
    private StringValueResolver embeddedValueResolver;

    public TimeLimiterAspect(TimeLimiterRegistry timeLimiterRegistry, TimeLimiterConfigurationProperties properties, @Nullable List<TimeLimiterAspectExt> timeLimiterAspectExtList, FallbackDecorators fallbackDecorators) {
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.properties = properties;
        this.timeLimiterAspectExtList = timeLimiterAspectExtList;
        this.fallbackDecorators = fallbackDecorators;
        this.cleanup();
    }

    @Pointcut(value="@within(timeLimiter) || @annotation(timeLimiter)", argNames="timeLimiter")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.timelimiter.annotation.TimeLimiter timeLimiter) {
    }

    @Around(value="matchAnnotatedClassOrMethod(timeLimiterAnnotation)", argNames="proceedingJoinPoint, timeLimiterAnnotation")
    public Object timeLimiterAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.timelimiter.annotation.TimeLimiter timeLimiterAnnotation) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (timeLimiterAnnotation == null) {
            timeLimiterAnnotation = TimeLimiterAspect.getTimeLimiterAnnotation(proceedingJoinPoint);
        }
        if (timeLimiterAnnotation == null) {
            return proceedingJoinPoint.proceed();
        }
        String name = timeLimiterAnnotation.name();
        TimeLimiter timeLimiter = this.getOrCreateTimeLimiter(methodName, name);
        Class<?> returnType = method.getReturnType();
        String fallbackMethodValue = ValueResolver.resolve(this.embeddedValueResolver, timeLimiterAnnotation.fallbackMethod());
        if (StringUtils.isEmpty((Object)fallbackMethodValue)) {
            return this.proceed(proceedingJoinPoint, methodName, timeLimiter, returnType);
        }
        FallbackMethod fallbackMethod = FallbackMethod.create(fallbackMethodValue, method, proceedingJoinPoint.getArgs(), proceedingJoinPoint.getTarget());
        return this.fallbackDecorators.decorate(fallbackMethod, (CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> this.proceed(proceedingJoinPoint, methodName, timeLimiter, returnType)).apply();
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, String methodName, TimeLimiter timeLimiter, Class<?> returnType) throws Throwable {
        if (this.timeLimiterAspectExtList != null && !this.timeLimiterAspectExtList.isEmpty()) {
            for (TimeLimiterAspectExt timeLimiterAspectExt : this.timeLimiterAspectExtList) {
                if (!timeLimiterAspectExt.canHandleReturnType(returnType)) continue;
                return timeLimiterAspectExt.handle(proceedingJoinPoint, timeLimiter, methodName);
            }
        }
        if (!CompletionStage.class.isAssignableFrom(returnType)) {
            throw new IllegalStateException("Not supported type by TimeLimiterAspect");
        }
        return TimeLimiterAspect.handleJoinPointCompletableFuture(proceedingJoinPoint, timeLimiter);
    }

    private TimeLimiter getOrCreateTimeLimiter(String methodName, String name) {
        TimeLimiter timeLimiter = this.timeLimiterRegistry.timeLimiter(name);
        if (logger.isDebugEnabled()) {
            TimeLimiterConfig timeLimiterConfig = timeLimiter.getTimeLimiterConfig();
            logger.debug("Created or retrieved time limiter '{}' with timeout duration '{}' and cancelRunningFuture '{}' for method: '{}'", new Object[]{name, timeLimiterConfig.getTimeoutDuration(), timeLimiterConfig.shouldCancelRunningFuture(), methodName});
        }
        return timeLimiter;
    }

    @Nullable
    private static io.github.resilience4j.timelimiter.annotation.TimeLimiter getTimeLimiterAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (proceedingJoinPoint.getTarget() instanceof Proxy) {
            logger.debug("The TimeLimiter annotation is kept on a interface which is acting as a proxy");
            return AnnotationExtractor.extractAnnotationFromProxy(proceedingJoinPoint.getTarget(), io.github.resilience4j.timelimiter.annotation.TimeLimiter.class);
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.timelimiter.annotation.TimeLimiter.class);
    }

    private static Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, TimeLimiter timeLimiter) throws Throwable {
        return timeLimiter.executeCompletionStage(timeLimiterExecutorService, () -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    private void cleanup() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            timeLimiterExecutorService.shutdown();
            try {
                if (!timeLimiterExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    timeLimiterExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!timeLimiterExecutorService.isTerminated()) {
                    timeLimiterExecutorService.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }));
    }

    public int getOrder() {
        return this.properties.getTimeLimiterAspectOrder();
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }
}

