/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.configure;

import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspectExt;
import io.github.resilience4j.timelimiter.transformer.TimeLimiterTransformer;
import io.github.resilience4j.utils.AspectUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxJava2TimeLimiterAspectExt
implements TimeLimiterAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(RxJava2TimeLimiterAspectExt.class);
    private final Set<Class<?>> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class<?> returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, TimeLimiter timeLimiter, String methodName) throws Throwable {
        TimeLimiterTransformer timeLimiterTransformer = TimeLimiterTransformer.of((TimeLimiter)timeLimiter);
        Object returnValue = proceedingJoinPoint.proceed();
        return RxJava2TimeLimiterAspectExt.executeRxJava2Aspect(timeLimiterTransformer, returnValue);
    }

    private static Object executeRxJava2Aspect(TimeLimiterTransformer timeLimiterTransformer, Object returnValue) {
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.compose((ObservableTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.compose((SingleTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.compose((CompletableTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.compose((MaybeTransformer)timeLimiterTransformer);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.compose((FlowableTransformer)timeLimiterTransformer);
        }
        logger.error("Unsupported type for TimeLimiter RxJava2 {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the TimeLimiter in RxJava2 :" + returnValue.getClass().getName());
    }
}

