/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.timelimiter.configure;

import io.github.resilience4j.reactor.timelimiter.TimeLimiterOperator;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.configure.TimeLimiterAspectExt;
import java.util.function.Function;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorTimeLimiterAspectExt
implements TimeLimiterAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(ReactorTimeLimiterAspectExt.class);

    @Override
    public boolean canHandleReturnType(Class<?> returnType) {
        return Flux.class.isAssignableFrom(returnType) || Mono.class.isAssignableFrom(returnType);
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, TimeLimiter timeLimiter, String methodName) throws Throwable {
        Object returnValue = proceedingJoinPoint.proceed();
        if (Flux.class.isAssignableFrom(returnValue.getClass())) {
            Flux fluxReturnValue = (Flux)returnValue;
            return fluxReturnValue.compose((Function)TimeLimiterOperator.of((TimeLimiter)timeLimiter));
        }
        if (Mono.class.isAssignableFrom(returnValue.getClass())) {
            Mono monoReturnValue = (Mono)returnValue;
            return monoReturnValue.compose((Function)TimeLimiterOperator.of((TimeLimiter)timeLimiter));
        }
        logger.error("Unsupported type for Reactor timeLimiter {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the timeLimiter in Reactor :" + returnValue.getClass().getName());
    }
}

