/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.configure;

import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.configure.RetryAspectExt;
import io.github.resilience4j.retry.configure.RetryConfigurationProperties;
import io.github.resilience4j.utils.AnnotationExtractor;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@Aspect
public class RetryAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(RetryAspect.class);
    private static final ScheduledExecutorService retryExecutorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private final RetryConfigurationProperties retryConfigurationProperties;
    private final RetryRegistry retryRegistry;
    @Nullable
    private final List<RetryAspectExt> retryAspectExtList;
    private final FallbackDecorators fallbackDecorators;

    public RetryAspect(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, @Autowired(required=false) List<RetryAspectExt> retryAspectExtList, FallbackDecorators fallbackDecorators) {
        this.retryConfigurationProperties = retryConfigurationProperties;
        this.retryRegistry = retryRegistry;
        this.retryAspectExtList = retryAspectExtList;
        this.fallbackDecorators = fallbackDecorators;
        this.cleanup();
    }

    @Pointcut(value="@within(retry) || @annotation(retry)", argNames="retry")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.retry.annotation.Retry retry) {
    }

    @Around(value="matchAnnotatedClassOrMethod(retryAnnotation)", argNames="proceedingJoinPoint, retryAnnotation")
    public Object retryAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.retry.annotation.Retry retryAnnotation) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (retryAnnotation == null) {
            retryAnnotation = this.getRetryAnnotation(proceedingJoinPoint);
        }
        if (retryAnnotation == null) {
            return proceedingJoinPoint.proceed();
        }
        String backend = retryAnnotation.name();
        Retry retry = this.getOrCreateRetry(methodName, backend);
        Class<?> returnType = method.getReturnType();
        if (StringUtils.isEmpty((Object)retryAnnotation.fallbackMethod())) {
            return this.proceed(proceedingJoinPoint, methodName, retry, returnType);
        }
        FallbackMethod fallbackMethod = FallbackMethod.create(retryAnnotation.fallbackMethod(), method, proceedingJoinPoint.getArgs(), proceedingJoinPoint.getTarget());
        return this.fallbackDecorators.decorate(fallbackMethod, (CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> this.proceed(proceedingJoinPoint, methodName, retry, returnType)).apply();
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, String methodName, Retry retry, Class<?> returnType) throws Throwable {
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, retry);
        }
        if (this.retryAspectExtList != null && !this.retryAspectExtList.isEmpty()) {
            for (RetryAspectExt retryAspectExt : this.retryAspectExtList) {
                if (!retryAspectExt.canHandleReturnType(returnType)) continue;
                return retryAspectExt.handle(proceedingJoinPoint, retry, methodName);
            }
        }
        return this.handleDefaultJoinPoint(proceedingJoinPoint, retry);
    }

    private Retry getOrCreateRetry(String methodName, String backend) {
        Retry retry = this.retryRegistry.retry(backend);
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved retry '{}' with max attempts rate '{}'  for method: '{}'", new Object[]{backend, retry.getRetryConfig().getResultPredicate(), methodName});
        }
        return retry;
    }

    @Nullable
    private io.github.resilience4j.retry.annotation.Retry getRetryAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.retry.annotation.Retry.class);
    }

    private Object handleDefaultJoinPoint(ProceedingJoinPoint proceedingJoinPoint, Retry retry) throws Throwable {
        return retry.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, Retry retry) {
        return retry.executeCompletionStage(retryExecutorService, () -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    public int getOrder() {
        return this.retryConfigurationProperties.getRetryAspectOrder();
    }

    private void cleanup() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            retryExecutorService.shutdown();
            try {
                if (!retryExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                    retryExecutorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!retryExecutorService.isTerminated()) {
                    retryExecutorService.shutdownNow();
                }
                Thread.currentThread().interrupt();
            }
        }));
    }
}

