/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.utils;

import io.github.resilience4j.core.lang.Nullable;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationExtractor.class);

    private AnnotationExtractor() {
    }

    @Nullable
    public static <T extends Annotation> T extract(Class<?> targetClass, Class<T> annotationClass) {
        T annotation = null;
        if (targetClass.isAnnotationPresent(annotationClass) && (annotation = (T)targetClass.getAnnotation(annotationClass)) == null && logger.isDebugEnabled()) {
            logger.debug("TargetClass has no annotation '{}'", (Object)annotationClass.getSimpleName());
            annotation = targetClass.getDeclaredAnnotation(annotationClass);
            if (annotation == null && logger.isDebugEnabled()) {
                logger.debug("TargetClass has no declared annotation '{}'", (Object)annotationClass.getSimpleName());
            }
        }
        return annotation;
    }
}

