/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.configure;

import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.configure.ReactorRetryAspectExt;
import io.github.resilience4j.retry.configure.RetryAspect;
import io.github.resilience4j.retry.configure.RetryAspectExt;
import io.github.resilience4j.retry.configure.RetryConfigurationProperties;
import io.github.resilience4j.retry.configure.RxJava2RetryAspectExt;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.utils.ReactorOnClasspathCondition;
import io.github.resilience4j.utils.RxJava2OnClasspathCondition;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RetryConfiguration {
    @Bean
    public RetryRegistry retryRegistry(RetryConfigurationProperties retryConfigurationProperties, EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry) {
        RetryRegistry retryRegistry = this.createRetryRegistry(retryConfigurationProperties);
        this.registerEventConsumer(retryRegistry, retryEventConsumerRegistry, retryConfigurationProperties);
        retryConfigurationProperties.getBackends().forEach((name, properties) -> retryRegistry.retry(name, retryConfigurationProperties.createRetryConfig((String)name)));
        return retryRegistry;
    }

    private RetryRegistry createRetryRegistry(RetryConfigurationProperties retryConfigurationProperties) {
        Map<String, RetryConfig> configs = retryConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> retryConfigurationProperties.createRetryConfig((RetryConfigurationProperties.BackendProperties)entry.getValue())));
        return RetryRegistry.of(configs);
    }

    private void registerEventConsumer(RetryRegistry retryRegistry, EventConsumerRegistry<RetryEvent> eventConsumerRegistry, RetryConfigurationProperties retryConfigurationProperties) {
        retryRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getAddedEntry(), retryConfigurationProperties));
    }

    private void registerEventConsumer(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, Retry retry, RetryConfigurationProperties retryConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(retryConfigurationProperties.getBackendProperties(retry.getName())).map(RetryConfigurationProperties.BackendProperties::getEventConsumerBufferSize).orElse(100);
        retry.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(retry.getName(), eventConsumerBufferSize));
    }

    @Bean
    public RetryAspect retryAspect(RetryConfigurationProperties retryConfigurationProperties, RetryRegistry retryRegistry, @Autowired(required=false) List<RetryAspectExt> retryAspectExtList, FallbackDecorators fallbackDecorators) {
        return new RetryAspect(retryConfigurationProperties, retryRegistry, retryAspectExtList, fallbackDecorators);
    }

    @Bean
    @Conditional(value={RxJava2OnClasspathCondition.class})
    public RxJava2RetryAspectExt rxJava2RetryAspectExt() {
        return new RxJava2RetryAspectExt();
    }

    @Bean
    @Conditional(value={ReactorOnClasspathCondition.class})
    public ReactorRetryAspectExt reactorRetryAspectExt() {
        return new ReactorRetryAspectExt();
    }

    @Bean
    public EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }
}

