/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

public class RateLimiterConfigurationProperties {
    private int rateLimiterAspectOrder = Integer.MAX_VALUE;
    private Map<String, LimiterProperties> limiters = new HashMap<String, LimiterProperties>();
    private Map<String, LimiterProperties> configs = new HashMap<String, LimiterProperties>();

    public RateLimiterConfig createRateLimiterConfig(@Nullable LimiterProperties limiterProperties) {
        if (limiterProperties == null) {
            return RateLimiterConfig.ofDefaults();
        }
        if (!StringUtils.isEmpty((Object)limiterProperties.getBaseConfig())) {
            LimiterProperties baseProperties = this.configs.get(limiterProperties.baseConfig);
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(limiterProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, limiterProperties);
        }
        return this.buildRateLimiterConfig(RateLimiterConfig.custom(), limiterProperties);
    }

    private RateLimiterConfig buildConfigFromBaseConfig(LimiterProperties baseProperties, LimiterProperties backendProperties) {
        RateLimiterConfig baseConfig = this.buildRateLimiterConfig(RateLimiterConfig.custom(), baseProperties);
        return this.buildRateLimiterConfig(RateLimiterConfig.from((RateLimiterConfig)baseConfig), backendProperties);
    }

    private RateLimiterConfig buildRateLimiterConfig(RateLimiterConfig.Builder builder, @Nullable LimiterProperties limiterProperties) {
        if (limiterProperties == null) {
            return RateLimiterConfig.ofDefaults();
        }
        if (limiterProperties.getLimitForPeriod() != null) {
            builder.limitForPeriod(limiterProperties.getLimitForPeriod().intValue());
        }
        if (limiterProperties.getLimitRefreshPeriodInMillis() != null) {
            builder.limitRefreshPeriod(Duration.ofMillis(limiterProperties.getLimitRefreshPeriodInMillis().intValue()));
        }
        if (limiterProperties.getTimeoutInMillis() != null) {
            builder.timeoutDuration(Duration.ofMillis(limiterProperties.getTimeoutInMillis().intValue()));
        }
        return builder.build();
    }

    private LimiterProperties getLimiterProperties(String limiter) {
        return this.limiters.get(limiter);
    }

    public RateLimiterConfig createRateLimiterConfig(String limiter) {
        return this.createRateLimiterConfig(this.getLimiterProperties(limiter));
    }

    public int getRateLimiterAspectOrder() {
        return this.rateLimiterAspectOrder;
    }

    public void setRateLimiterAspectOrder(int rateLimiterAspectOrder) {
        this.rateLimiterAspectOrder = rateLimiterAspectOrder;
    }

    public Map<String, LimiterProperties> getLimiters() {
        return this.limiters;
    }

    public Map<String, LimiterProperties> getConfigs() {
        return this.configs;
    }

    public static class LimiterProperties {
        private Integer limitForPeriod;
        private Integer limitRefreshPeriodInMillis;
        private Integer timeoutInMillis;
        private Boolean subscribeForEvents = false;
        private Boolean registerHealthIndicator = false;
        private Integer eventConsumerBufferSize = 100;
        @Nullable
        private String baseConfig;

        @Nullable
        public Integer getLimitForPeriod() {
            return this.limitForPeriod;
        }

        public void setLimitForPeriod(Integer limitForPeriod) {
            this.limitForPeriod = limitForPeriod;
        }

        @Nullable
        public Integer getLimitRefreshPeriodInMillis() {
            return this.limitRefreshPeriodInMillis;
        }

        public void setLimitRefreshPeriodInMillis(Integer limitRefreshPeriodInMillis) {
            this.limitRefreshPeriodInMillis = limitRefreshPeriodInMillis;
        }

        @Nullable
        public Integer getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        public void setTimeoutInMillis(Integer timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
        }

        public Boolean getSubscribeForEvents() {
            return this.subscribeForEvents;
        }

        public void setSubscribeForEvents(Boolean subscribeForEvents) {
            this.subscribeForEvents = subscribeForEvents;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public void setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public void setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
        }
    }
}

