/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.fallback;

import io.github.resilience4j.core.lang.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class FallbackMethod {
    private static final Map<MethodMeta, Map<Class<?>, Method>> RECOVERY_METHODS_CACHE = new ConcurrentReferenceHashMap();
    private final Map<Class<?>, Method> recoveryMethods;
    private final Object[] args;
    private final Object target;
    private final Class<?> returnType;

    public FallbackMethod(String recoveryMethodName, Method originalMethod, Object[] args, Object target) throws NoSuchMethodException {
        Object[] params = originalMethod.getParameterTypes();
        Class<?> originalReturnType = originalMethod.getReturnType();
        Map<Class<?>, Method> methods = FallbackMethod.extractMethods(recoveryMethodName, params, originalReturnType, target.getClass());
        if (methods.isEmpty()) {
            throw new NoSuchMethodException(String.format("%s %s.%s(%s,%s)", originalReturnType, target.getClass(), recoveryMethodName, StringUtils.arrayToDelimitedString((Object[])params, (String)","), Throwable.class));
        }
        this.recoveryMethods = methods;
        this.args = args;
        this.target = target;
        this.returnType = originalReturnType;
    }

    @Nullable
    public Object recover(Throwable thrown) throws Throwable {
        if (this.recoveryMethods.size() == 1) {
            Map.Entry<Class<?>, Method> entry = this.recoveryMethods.entrySet().iterator().next();
            if (entry.getKey().isAssignableFrom(thrown.getClass())) {
                return this.invoke(entry.getValue(), thrown);
            }
            throw thrown;
        }
        Method recovery = null;
        for (Class<?> thrownClass = thrown.getClass(); recovery == null && thrownClass != Object.class; thrownClass = thrownClass.getSuperclass()) {
            recovery = this.recoveryMethods.get(thrownClass);
        }
        if (recovery == null) {
            throw thrown;
        }
        return this.invoke(recovery, thrown);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(Method recovery, Throwable throwable) throws IllegalAccessException, InvocationTargetException {
        boolean accessible = recovery.isAccessible();
        try {
            if (!accessible) {
                ReflectionUtils.makeAccessible((Method)recovery);
            }
            if (this.args.length != 0) {
                Object[] newArgs = Arrays.copyOf(this.args, this.args.length + 1);
                newArgs[this.args.length] = throwable;
                Object object = recovery.invoke(this.target, newArgs);
                return object;
            }
            Object object = recovery.invoke(this.target, throwable);
            return object;
        }
        finally {
            if (!accessible) {
                recovery.setAccessible(false);
            }
        }
    }

    private static Map<Class<?>, Method> extractMethods(String recoveryMethodName, Class<?>[] params, Class<?> originalReturnType, Class<?> targetClass) {
        MethodMeta methodMeta = new MethodMeta(recoveryMethodName, params, originalReturnType, targetClass);
        Map<Class<?>, Method> cachedMethods = RECOVERY_METHODS_CACHE.get(methodMeta);
        if (cachedMethods != null) {
            return cachedMethods;
        }
        HashMap methods = new HashMap();
        ReflectionUtils.doWithMethods(targetClass, method -> {
            Class<?>[] recoveryParams = method.getParameterTypes();
            methods.put(recoveryParams[recoveryParams.length - 1], method);
        }, method -> {
            if (!method.getName().equals(recoveryMethodName) || method.getParameterCount() != params.length + 1) {
                return false;
            }
            if (!originalReturnType.isAssignableFrom(method.getReturnType())) {
                return false;
            }
            Class<?>[] targetParams = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == targetParams[i]) continue;
                return false;
            }
            return Throwable.class.isAssignableFrom(targetParams[params.length]);
        });
        RECOVERY_METHODS_CACHE.putIfAbsent(methodMeta, methods);
        return methods;
    }

    private static class MethodMeta {
        final String recoveryMethodName;
        final Class<?>[] params;
        final Class<?> returnType;
        final Class<?> targetClass;

        MethodMeta(String recoveryMethodName, Class<?>[] params, Class<?> returnType, Class<?> targetClass) {
            this.recoveryMethodName = recoveryMethodName;
            this.params = params;
            this.returnType = returnType;
            this.targetClass = targetClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodMeta that = (MethodMeta)o;
            return this.targetClass.equals(that.targetClass) && this.recoveryMethodName.equals(that.recoveryMethodName) && this.returnType.equals(that.returnType) && Arrays.equals(this.params, that.params);
        }

        public int hashCode() {
            return this.targetClass.getName().hashCode() ^ this.recoveryMethodName.hashCode();
        }
    }
}

