/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.time.DurationMin;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CircuitBreakerConfigurationProperties {
    private int circuitBreakerAspectOrder = 0x7FFFFFFE;
    private Map<String, BackendProperties> backends = new HashMap<String, BackendProperties>();
    private Map<String, BackendProperties> configs = new HashMap<String, BackendProperties>();

    public int getCircuitBreakerAspectOrder() {
        return this.circuitBreakerAspectOrder;
    }

    public void setCircuitBreakerAspectOrder(int circuitBreakerAspectOrder) {
        this.circuitBreakerAspectOrder = circuitBreakerAspectOrder;
    }

    public Optional<BackendProperties> findCircuitBreakerProperties(String name) {
        return Optional.ofNullable(this.backends.get(name));
    }

    public CircuitBreakerConfig createCircuitBreakerConfig(BackendProperties backendProperties) {
        if (backendProperties.getBaseConfig() != null) {
            BackendProperties baseProperties = this.configs.get(backendProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(backendProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(backendProperties, baseProperties);
        }
        return this.buildConfig(CircuitBreakerConfig.custom(), backendProperties);
    }

    private CircuitBreakerConfig buildConfigFromBaseConfig(BackendProperties backendProperties, BackendProperties baseProperties) {
        CircuitBreakerConfig baseConfig = this.buildConfig(CircuitBreakerConfig.custom(), baseProperties);
        return this.buildConfig(CircuitBreakerConfig.from((CircuitBreakerConfig)baseConfig), backendProperties);
    }

    private CircuitBreakerConfig buildConfig(CircuitBreakerConfig.Builder builder, BackendProperties properties) {
        if (properties.getWaitDurationInOpenState() != null) {
            builder.waitDurationInOpenState(properties.getWaitDurationInOpenState());
        }
        if (properties.getFailureRateThreshold() != null) {
            builder.failureRateThreshold((float)properties.getFailureRateThreshold().intValue());
        }
        if (properties.getRingBufferSizeInClosedState() != null) {
            builder.ringBufferSizeInClosedState(properties.getRingBufferSizeInClosedState().intValue());
        }
        if (properties.getRingBufferSizeInHalfOpenState() != null) {
            builder.ringBufferSizeInHalfOpenState(properties.getRingBufferSizeInHalfOpenState().intValue());
        }
        if (properties.recordFailurePredicate != null) {
            this.buildRecordFailurePredicate(properties, builder);
        }
        if (properties.recordExceptions != null) {
            builder.recordExceptions(properties.recordExceptions);
        }
        if (properties.ignoreExceptions != null) {
            builder.ignoreExceptions(properties.ignoreExceptions);
        }
        if (properties.automaticTransitionFromOpenToHalfOpenEnabled != null) {
            builder.automaticTransitionFromOpenToHalfOpenEnabled(properties.automaticTransitionFromOpenToHalfOpenEnabled.booleanValue());
        }
        return builder.build();
    }

    protected void buildRecordFailurePredicate(BackendProperties properties, CircuitBreakerConfig.Builder builder) {
        builder.recordFailure((Predicate)BeanUtils.instantiateClass(properties.getRecordFailurePredicate()));
    }

    public Map<String, BackendProperties> getBackends() {
        return this.backends;
    }

    public Map<String, BackendProperties> getConfigs() {
        return this.configs;
    }

    public static class BackendProperties {
        @DurationMin(seconds=1L)
        @Nullable
        private @DurationMin(seconds=1L) Duration waitDurationInOpenState;
        @Min(value=1L)
        @Max(value=100L)
        @Nullable
        private @Min(value=1L) @Max(value=100L) Integer failureRateThreshold;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer ringBufferSizeInClosedState;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer ringBufferSizeInHalfOpenState;
        @Nullable
        private Boolean automaticTransitionFromOpenToHalfOpenEnabled;
        @Min(value=1L)
        private @Min(value=1L) Integer eventConsumerBufferSize = 100;
        @NotNull
        private Boolean registerHealthIndicator = true;
        @Nullable
        private Class<Predicate<Throwable>> recordFailurePredicate;
        @Nullable
        private Class<? extends Throwable>[] recordExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Nullable
        private String baseConfig;

        @Deprecated
        public void setWaitInterval(Integer waitInterval) {
            this.waitDurationInOpenState = Duration.ofMillis(waitInterval.intValue());
        }

        @Deprecated
        public Duration getWaitInterval() {
            return this.getWaitDurationInOpenState();
        }

        @Nullable
        public Integer getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public void setFailureRateThreshold(Integer failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
        }

        @Nullable
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public void setWaitDurationInOpenState(Duration waitDurationInOpenState) {
            this.waitDurationInOpenState = waitDurationInOpenState;
        }

        @Nullable
        public Integer getRingBufferSizeInClosedState() {
            return this.ringBufferSizeInClosedState;
        }

        public void setRingBufferSizeInClosedState(Integer ringBufferSizeInClosedState) {
            this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
        }

        @Nullable
        public Integer getRingBufferSizeInHalfOpenState() {
            return this.ringBufferSizeInHalfOpenState;
        }

        public void setRingBufferSizeInHalfOpenState(Integer ringBufferSizeInHalfOpenState) {
            this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
        }

        public Boolean getAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public void setAutomaticTransitionFromOpenToHalfOpenEnabled(Boolean automaticTransitionFromOpenToHalfOpenEnabled) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public void setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
        }

        @Nullable
        public Class<Predicate<Throwable>> getRecordFailurePredicate() {
            return this.recordFailurePredicate;
        }

        public void setRecordFailurePredicate(Class<Predicate<Throwable>> recordFailurePredicate) {
            this.recordFailurePredicate = recordFailurePredicate;
        }

        @Nullable
        public Class<? extends Throwable>[] getRecordExceptions() {
            return this.recordExceptions;
        }

        public void setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
            this.recordExceptions = recordExceptions;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public void setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public void setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
        }
    }
}

