/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.lang.Nullable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Min;
import org.springframework.util.StringUtils;

public class BulkheadConfigurationProperties {
    private int bulkheadAspectOrder = 0x7FFFFFFD;
    private Map<String, BackendProperties> backends = new HashMap<String, BackendProperties>();
    private Map<String, BackendProperties> configs = new HashMap<String, BackendProperties>();

    public int getBulkheadAspectOrder() {
        return this.bulkheadAspectOrder;
    }

    public void setBulkheadAspectOrder(int bulkheadAspectOrder) {
        this.bulkheadAspectOrder = bulkheadAspectOrder;
    }

    @Nullable
    public BackendProperties getBackendProperties(String backend) {
        return this.backends.get(backend);
    }

    public BulkheadConfig createBulkheadConfig(String backend) {
        return this.createBulkheadConfig(this.getBackendProperties(backend));
    }

    public BulkheadConfig createBulkheadConfig(BackendProperties backendProperties) {
        if (!StringUtils.isEmpty((Object)backendProperties.getBaseConfig())) {
            BackendProperties baseProperties = this.configs.get(backendProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(backendProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(baseProperties, backendProperties);
        }
        return this.buildBulkheadConfig(BulkheadConfig.custom(), backendProperties);
    }

    private BulkheadConfig buildConfigFromBaseConfig(BackendProperties baseProperties, BackendProperties backendProperties) {
        BulkheadConfig baseConfig = this.buildBulkheadConfig(BulkheadConfig.custom(), baseProperties);
        return this.buildBulkheadConfig(BulkheadConfig.from((BulkheadConfig)baseConfig), backendProperties);
    }

    public BulkheadConfig buildBulkheadConfig(BulkheadConfig.Builder builder, BackendProperties properties) {
        if (properties == null) {
            return BulkheadConfig.custom().build();
        }
        if (properties.getMaxConcurrentCall() != null) {
            builder.maxConcurrentCalls(properties.getMaxConcurrentCall().intValue());
        }
        if (properties.getMaxWaitTime() != null) {
            builder.maxWaitTime(properties.getMaxWaitTime().longValue());
        }
        return builder.build();
    }

    public Map<String, BackendProperties> getBackends() {
        return this.backends;
    }

    public Map<String, BackendProperties> getConfigs() {
        return this.configs;
    }

    public static class BackendProperties {
        @Min(value=1L)
        private @Min(value=1L) Integer maxConcurrentCall;
        @Min(value=0L)
        private @Min(value=0L) Long maxWaitTime;
        @Min(value=1L)
        private @Min(value=1L) Integer eventConsumerBufferSize = 100;
        @Nullable
        private String baseConfig;

        public Integer getMaxConcurrentCall() {
            return this.maxConcurrentCall;
        }

        public void setMaxConcurrentCall(Integer maxConcurrentCall) {
            this.maxConcurrentCall = maxConcurrentCall;
        }

        public Long getMaxWaitTime() {
            return this.maxWaitTime;
        }

        public void setMaxWaitTime(Long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public void setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public void setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
        }
    }
}

