/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.configure;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.configure.BulkheadAspectExt;
import io.github.resilience4j.bulkhead.configure.BulkheadConfigurationProperties;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.fallback.FallbackDecorators;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.utils.AnnotationExtractor;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

@Aspect
public class BulkheadAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(BulkheadAspect.class);
    private final BulkheadConfigurationProperties bulkheadConfigurationProperties;
    private final BulkheadRegistry bulkheadRegistry;
    @Nullable
    private final List<BulkheadAspectExt> bulkheadAspectExts;
    private final FallbackDecorators fallbackDecorators;

    public BulkheadAspect(BulkheadConfigurationProperties backendMonitorPropertiesRegistry, BulkheadRegistry bulkheadRegistry, @Autowired(required=false) List<BulkheadAspectExt> bulkheadAspectExts, FallbackDecorators fallbackDecorators) {
        this.bulkheadConfigurationProperties = backendMonitorPropertiesRegistry;
        this.bulkheadRegistry = bulkheadRegistry;
        this.bulkheadAspectExts = bulkheadAspectExts;
        this.fallbackDecorators = fallbackDecorators;
    }

    @Pointcut(value="@within(Bulkhead) || @annotation(Bulkhead)", argNames="Bulkhead")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.bulkhead.annotation.Bulkhead Bulkhead2) {
    }

    @Around(value="matchAnnotatedClassOrMethod(bulkheadAnnotation)", argNames="proceedingJoinPoint, bulkheadAnnotation")
    public Object bulkheadAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, @Nullable io.github.resilience4j.bulkhead.annotation.Bulkhead bulkheadAnnotation) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (bulkheadAnnotation == null) {
            bulkheadAnnotation = this.geBulkheadAnnotation(proceedingJoinPoint);
        }
        if (bulkheadAnnotation == null) {
            return proceedingJoinPoint.proceed();
        }
        String backend = bulkheadAnnotation.name();
        Bulkhead bulkhead = this.getOrCreateBulkhead(methodName, backend);
        Class<?> returnType = method.getReturnType();
        if (StringUtils.isEmpty((Object)bulkheadAnnotation.fallbackMethod())) {
            return this.proceed(proceedingJoinPoint, methodName, bulkhead, returnType);
        }
        FallbackMethod fallbackMethod = new FallbackMethod(bulkheadAnnotation.fallbackMethod(), method, proceedingJoinPoint.getArgs(), proceedingJoinPoint.getTarget());
        return this.fallbackDecorators.decorate(fallbackMethod, (CheckedFunction0<Object>)(CheckedFunction0 & Serializable)() -> this.proceed(proceedingJoinPoint, methodName, bulkhead, returnType)).apply();
    }

    private Object proceed(ProceedingJoinPoint proceedingJoinPoint, String methodName, Bulkhead bulkhead, Class<?> returnType) throws Throwable {
        if (this.bulkheadAspectExts != null && !this.bulkheadAspectExts.isEmpty()) {
            for (BulkheadAspectExt bulkHeadAspectExt : this.bulkheadAspectExts) {
                if (!bulkHeadAspectExt.canHandleReturnType(returnType)) continue;
                return bulkHeadAspectExt.handle(proceedingJoinPoint, bulkhead, methodName);
            }
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.handleJoinPointCompletableFuture(proceedingJoinPoint, bulkhead);
        }
        return this.handleJoinPoint(proceedingJoinPoint, bulkhead);
    }

    private Bulkhead getOrCreateBulkhead(String methodName, String backend) {
        Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(backend);
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved bulkhead '{}' with max concurrent call '{}' and max wait time '{}' for method: '{}'", new Object[]{backend, bulkhead.getBulkheadConfig().getMaxConcurrentCalls(), bulkhead.getBulkheadConfig().getMaxWaitTime(), methodName});
        }
        return bulkhead;
    }

    @Nullable
    private io.github.resilience4j.bulkhead.annotation.Bulkhead geBulkheadAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("bulkhead parameter is null");
        }
        return AnnotationExtractor.extract(proceedingJoinPoint.getTarget().getClass(), io.github.resilience4j.bulkhead.annotation.Bulkhead.class);
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead) throws Throwable {
        return bulkhead.executeCheckedSupplier(() -> ((ProceedingJoinPoint)proceedingJoinPoint).proceed());
    }

    private Object handleJoinPointCompletableFuture(ProceedingJoinPoint proceedingJoinPoint, Bulkhead bulkhead) {
        return bulkhead.executeCompletionStage(() -> {
            try {
                return (CompletionStage)proceedingJoinPoint.proceed();
            }
            catch (Throwable throwable) {
                throw new CompletionException(throwable);
            }
        });
    }

    public int getOrder() {
        return this.bulkheadConfigurationProperties.getBulkheadAspectOrder();
    }
}

