/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.configure;

import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerAspect;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.configure.RateLimiterAspectExt;
import io.github.resilience4j.ratelimiter.operator.RateLimiterOperator;
import io.github.resilience4j.utils.AspectUtil;
import io.reactivex.Completable;
import io.reactivex.CompletableOperator;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableOperator;
import io.reactivex.Maybe;
import io.reactivex.MaybeOperator;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.ObservableOperator;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleOperator;
import io.reactivex.SingleSource;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxJava2RateLimterAspectExt
implements RateLimiterAspectExt {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerAspect.class);
    private final Set<Class> rxSupportedTypes = AspectUtil.newHashSet(ObservableSource.class, SingleSource.class, CompletableSource.class, MaybeSource.class, Flowable.class);

    @Override
    public boolean canHandleReturnType(Class returnType) {
        return this.rxSupportedTypes.stream().anyMatch(classType -> classType.isAssignableFrom(returnType));
    }

    @Override
    public Object handle(ProceedingJoinPoint proceedingJoinPoint, RateLimiter rateLimiter, String methodName) throws Throwable {
        RateLimiterOperator rateLimiterOperator = RateLimiterOperator.of((RateLimiter)rateLimiter);
        Object returnValue = proceedingJoinPoint.proceed();
        return this.executeRxJava2Aspect(rateLimiterOperator, returnValue);
    }

    private Object executeRxJava2Aspect(RateLimiterOperator rateLimiterOperator, Object returnValue) {
        if (returnValue instanceof ObservableSource) {
            Observable observable = (Observable)returnValue;
            return observable.lift((ObservableOperator)rateLimiterOperator);
        }
        if (returnValue instanceof SingleSource) {
            Single single = (Single)returnValue;
            return single.lift((SingleOperator)rateLimiterOperator);
        }
        if (returnValue instanceof CompletableSource) {
            Completable completable = (Completable)returnValue;
            return completable.lift((CompletableOperator)rateLimiterOperator);
        }
        if (returnValue instanceof MaybeSource) {
            Maybe maybe = (Maybe)returnValue;
            return maybe.lift((MaybeOperator)rateLimiterOperator);
        }
        if (returnValue instanceof Flowable) {
            Flowable flowable = (Flowable)returnValue;
            return flowable.lift((FlowableOperator)rateLimiterOperator);
        }
        logger.error("Unsupported type for Rate limiter RxJava2 {}", (Object)returnValue.getClass().getTypeName());
        throw new IllegalArgumentException("Not Supported type for the Rate limiter in RxJava2 :" + returnValue.getClass().getName());
    }
}

