/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.configure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.circuitbreaker.utils.CircuitBreakerUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class CircuitBreakerAspect
implements Ordered {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerAspect.class);
    private final CircuitBreakerConfigurationProperties circuitBreakerProperties;
    private final CircuitBreakerRegistry circuitBreakerRegistry;

    public CircuitBreakerAspect(CircuitBreakerConfigurationProperties backendMonitorPropertiesRegistry, CircuitBreakerRegistry circuitBreakerRegistry) {
        this.circuitBreakerProperties = backendMonitorPropertiesRegistry;
        this.circuitBreakerRegistry = circuitBreakerRegistry;
    }

    @Pointcut(value="@within(circuitBreaker) || @annotation(circuitBreaker)", argNames="circuitBreaker")
    public void matchAnnotatedClassOrMethod(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker circuitBreaker) {
    }

    @Around(value="matchAnnotatedClassOrMethod(backendMonitored)", argNames="proceedingJoinPoint, backendMonitored")
    public Object circuitBreakerAroundAdvice(ProceedingJoinPoint proceedingJoinPoint, io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker backendMonitored) throws Throwable {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
        if (backendMonitored == null) {
            backendMonitored = this.getBackendMonitoredAnnotation(proceedingJoinPoint);
        }
        String backend = backendMonitored.name();
        CircuitBreaker circuitBreaker = this.getOrCreateCircuitBreaker(methodName, backend);
        return this.handleJoinPoint(proceedingJoinPoint, circuitBreaker, methodName);
    }

    private CircuitBreaker getOrCreateCircuitBreaker(String methodName, String backend) {
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(backend, () -> this.circuitBreakerProperties.createCircuitBreakerConfig(backend));
        if (logger.isDebugEnabled()) {
            logger.debug("Created or retrieved circuit breaker '{}' with failure rate '{}' and wait interval'{}' for method: '{}'", new Object[]{backend, Float.valueOf(circuitBreaker.getCircuitBreakerConfig().getFailureRateThreshold()), circuitBreaker.getCircuitBreakerConfig().getWaitDurationInOpenState(), methodName});
        }
        return circuitBreaker;
    }

    private io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker getBackendMonitoredAnnotation(ProceedingJoinPoint proceedingJoinPoint) {
        if (logger.isDebugEnabled()) {
            logger.debug("circuitBreaker parameter is null");
        }
        io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker circuitBreaker = null;
        Class<?> targetClass = proceedingJoinPoint.getTarget().getClass();
        if (targetClass.isAnnotationPresent(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class) && (circuitBreaker = targetClass.getAnnotation(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("TargetClass has no annotation 'CircuitBreaker'");
            }
            if ((circuitBreaker = targetClass.getDeclaredAnnotation(io.github.resilience4j.circuitbreaker.annotation.CircuitBreaker.class)) == null && logger.isDebugEnabled()) {
                logger.debug("TargetClass has no declared annotation 'CircuitBreaker'");
            }
        }
        return circuitBreaker;
    }

    private Object handleJoinPoint(ProceedingJoinPoint proceedingJoinPoint, CircuitBreaker circuitBreaker, String methodName) throws Throwable {
        CircuitBreakerUtils.isCallPermitted((CircuitBreaker)circuitBreaker);
        long start = System.nanoTime();
        try {
            Object returnValue = proceedingJoinPoint.proceed();
            long durationInNanos = System.nanoTime() - start;
            circuitBreaker.onSuccess(durationInNanos);
            return returnValue;
        }
        catch (Throwable throwable) {
            long durationInNanos = System.nanoTime() - start;
            circuitBreaker.onError(durationInNanos, throwable);
            if (logger.isDebugEnabled()) {
                logger.debug("Invocation of method '" + methodName + "' failed!", throwable);
            }
            throw throwable;
        }
    }

    public int getOrder() {
        return this.circuitBreakerProperties.getCircuitBreakerAspectOrder();
    }
}

