/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.monitoring.endpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTOFactory;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.reactor.adapter.ReactorAdapter;
import io.vavr.collection.Seq;
import java.util.function.Function;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.http.codec.ServerSentEvent;
import reactor.core.publisher.Flux;

@Endpoint(id="stream-circuitbreaker-events")
public class CircuitBreakerServerSideEvent {
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public CircuitBreakerServerSideEvent(CircuitBreakerRegistry circuitBreakerRegistry) {
        this.circuitBreakerRegistry = circuitBreakerRegistry;
    }

    @ReadOperation(produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> getAllCircuitBreakerServerSideEvent() {
        Seq eventStreams = this.circuitBreakerRegistry.getAllCircuitBreakers().map(circuitBreaker -> ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()));
        Function<CircuitBreakerEvent, String> data = this.getCircuitBreakerEventStringFunction();
        return Flux.merge((Iterable)eventStreams).map(cbEvent -> ServerSentEvent.builder().id(cbEvent.getCircuitBreakerName()).event(cbEvent.getEventType().name()).data((Object)((String)data.apply((CircuitBreakerEvent)cbEvent))).build());
    }

    @ReadOperation(produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> getEventsFilteredByCircuitBreakerName(@Selector String name) {
        CircuitBreaker givenCircuitBreaker = this.getCircuitBreaker(name);
        Seq eventStreams = this.circuitBreakerRegistry.getAllCircuitBreakers().filter(circuitBreaker -> circuitBreaker.getName().equals(givenCircuitBreaker.getName())).map(circuitBreaker -> ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()));
        Function<CircuitBreakerEvent, String> data = this.getCircuitBreakerEventStringFunction();
        return Flux.merge((Iterable)eventStreams).map(cbEvent -> ServerSentEvent.builder().id(cbEvent.getCircuitBreakerName()).event(cbEvent.getEventType().name()).data((Object)((String)data.apply((CircuitBreakerEvent)cbEvent))).build());
    }

    @ReadOperation(produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> getEventsFilteredByCircuitBreakerNameAndEventType(@Selector String name, @Selector String eventType) {
        CircuitBreaker givenCircuitBreaker = this.getCircuitBreaker(name);
        Seq eventStream = this.circuitBreakerRegistry.getAllCircuitBreakers().filter(circuitBreaker -> circuitBreaker.getName().equals(givenCircuitBreaker.getName())).map(circuitBreaker -> ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()));
        Function<CircuitBreakerEvent, String> data = this.getCircuitBreakerEventStringFunction();
        return Flux.merge((Iterable)eventStream).filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase())).map(cbEvent -> ServerSentEvent.builder().id(cbEvent.getCircuitBreakerName()).event(cbEvent.getEventType().name()).data((Object)((String)data.apply((CircuitBreakerEvent)cbEvent))).build());
    }

    private Function<CircuitBreakerEvent, String> getCircuitBreakerEventStringFunction() {
        return cbEvent -> {
            try {
                return this.jsonMapper.writeValueAsString((Object)CircuitBreakerEventDTOFactory.createCircuitBreakerEventDTO((CircuitBreakerEvent)cbEvent));
            }
            catch (JsonProcessingException jsonProcessingException) {
                return "";
            }
        };
    }

    private CircuitBreaker getCircuitBreaker(String circuitBreakerName) {
        return this.circuitBreakerRegistry.circuitBreaker(circuitBreakerName);
    }
}

